/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import com.google.common.collect.ImmutableList;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.patchouli.client.base.ClientAdvancements;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.AbstractReadStateHolder;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookIcon;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.EntryDisplayState;
import vazkii.patchouli.client.book.page.PageEmpty;
import vazkii.patchouli.client.book.page.PageEntity;
import vazkii.patchouli.client.book.page.PageQuest;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.util.ItemStackUtil;

public class BookEntry
extends AbstractReadStateHolder
implements Comparable<BookEntry> {
    String name;
    String category;
    String flag;
    @SerializedName(value="icon")
    String iconRaw;
    boolean priority = false;
    boolean secret = false;
    @SerializedName(value="read_by_default")
    boolean readByDefault = false;
    BookPage[] pages;
    String advancement;
    String turnin;
    int sortnum;
    transient ResourceLocation resource;
    transient Book book;
    transient Book trueProvider;
    transient BookCategory lcategory = null;
    transient BookIcon icon = null;
    transient List<BookPage> realPages = new ArrayList<BookPage>();
    transient List<ItemStackUtil.StackWrapper> relevantStacks = new LinkedList<ItemStackUtil.StackWrapper>();
    transient boolean locked;
    transient boolean built;
    private static final List<BookPage> NO_PAGE = ImmutableList.of((Object)new PageEmpty());

    public String getName() {
        return this.name;
    }

    public List<BookPage> getPages() {
        List<BookPage> pages = PatchouliConfig.disableAdvancementLocking ? this.realPages : this.realPages.stream().filter(BookPage::isPageUnlocked).collect(Collectors.toList());
        return pages.isEmpty() ? NO_PAGE : pages;
    }

    public int getPageFromAnchor(String anchor) {
        List<BookPage> pages = this.getPages();
        for (int i = 0; i < pages.size(); ++i) {
            BookPage page = pages.get(i);
            if (!anchor.equals(page.anchor)) continue;
            return i;
        }
        return -1;
    }

    public boolean isPriority() {
        return this.priority;
    }

    public BookIcon getIcon() {
        if (this.icon == null) {
            this.icon = new BookIcon(this.iconRaw);
        }
        return this.icon;
    }

    public BookCategory getCategory() {
        if (this.lcategory == null) {
            this.lcategory = this.category.contains(":") ? this.book.contents.categories.get(new ResourceLocation(this.category)) : this.book.contents.categories.get(new ResourceLocation(this.book.getModNamespace(), this.category));
        }
        return this.lcategory;
    }

    public void updateLockStatus() {
        boolean currLocked = this.locked;
        this.locked = this.advancement != null && !this.advancement.isEmpty() && !ClientAdvancements.hasDone(this.advancement);
        boolean dirty = false;
        if (!this.locked && currLocked != this.locked) {
            dirty = true;
            this.book.markUpdated();
        }
        if (!dirty && !this.readStateDirty && this.getReadState() == EntryDisplayState.PENDING && ClientAdvancements.hasDone(this.turnin)) {
            dirty = true;
        }
        if (dirty) {
            this.markReadStateDirty();
        }
    }

    public boolean isLocked() {
        if (this.isSecret()) {
            return this.locked;
        }
        return !PatchouliConfig.disableAdvancementLocking && this.locked;
    }

    public boolean isSecret() {
        return this.secret;
    }

    public boolean shouldHide() {
        return this.isSecret() && this.isLocked();
    }

    public ResourceLocation getResource() {
        return this.resource;
    }

    public boolean canAdd() {
        return (this.flag == null || this.flag.isEmpty() || PatchouliConfig.getConfigFlag(this.flag)) && this.getCategory() != null;
    }

    public boolean isFoundByQuery(String query) {
        if (this.getName().toLowerCase().contains(query)) {
            return true;
        }
        for (ItemStackUtil.StackWrapper wrapper : this.relevantStacks) {
            if (!StringUtils.func_76338_a((String)wrapper.stack.func_82833_r()).toLowerCase().contains(query)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(BookEntry o) {
        EntryDisplayState otherState;
        if (o.locked != this.locked) {
            return this.locked ? 1 : -1;
        }
        EntryDisplayState ourState = this.getReadState();
        if (ourState != (otherState = o.getReadState())) {
            return ourState.compareTo(otherState);
        }
        if (o.priority != this.priority) {
            return this.priority ? -1 : 1;
        }
        int sort = this.sortnum - o.sortnum;
        return sort == 0 ? this.name.compareTo(o.name) : sort;
    }

    public void setBook(Book book) {
        if (book.isExtension) {
            this.book = book.extensionTarget;
            this.trueProvider = book;
        } else {
            this.book = book;
        }
    }

    public void build(ResourceLocation resource) {
        if (this.built) {
            return;
        }
        this.resource = resource;
        for (int i = 0; i < this.pages.length; ++i) {
            if (!this.pages[i].canAdd(this.book)) continue;
            try {
                this.pages[i].build(this, i);
                if (this.pages[i] instanceof PageEntity) {
                    PageEntity page = (PageEntity)this.pages[i];
                    if (page.errored) continue;
                    this.realPages.add(page);
                    continue;
                }
                this.realPages.add(this.pages[i]);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Error while loading entry " + resource + " page " + i, e);
            }
        }
        this.built = true;
    }

    public void addRelevantStack(ItemStack stack, int page) {
        ItemStackUtil.StackWrapper wrapper = ItemStackUtil.wrapStack(stack);
        this.relevantStacks.add(wrapper);
        if (!this.book.contents.recipeMappings.containsKey(wrapper)) {
            this.book.contents.recipeMappings.put(wrapper, (Pair<BookEntry, Integer>)Pair.of((Object)this, (Object)(page / 2)));
        }
    }

    public boolean isStackRelevant(ItemStack stack) {
        return this.relevantStacks.contains(ItemStackUtil.wrapStack(stack));
    }

    public Book getBook() {
        return this.book;
    }

    public Book getTrueProvider() {
        return this.trueProvider;
    }

    public boolean isExtension() {
        return this.getTrueProvider() != null && this.getTrueProvider() != this.getBook();
    }

    @Override
    protected EntryDisplayState computeReadState() {
        PersistentData.DataHolder.BookData data = PersistentData.data.getBookData(this.book);
        if (!(data == null || this.getResource() == null || this.readByDefault || this.isLocked() || data.viewedEntries.contains(this.getResource().toString()))) {
            return EntryDisplayState.UNREAD;
        }
        if (this.turnin != null && !this.turnin.isEmpty() && !ClientAdvancements.hasDone(this.turnin)) {
            return EntryDisplayState.PENDING;
        }
        for (BookPage page : this.pages) {
            if (!(page instanceof PageQuest) || !((PageQuest)page).isCompleted(this.book)) continue;
            return EntryDisplayState.COMPLETED;
        }
        return EntryDisplayState.NEUTRAL;
    }

    @Override
    public void markReadStateDirty() {
        super.markReadStateDirty();
        this.getCategory().markReadStateDirty();
    }
}

