/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.base;

import javax.annotation.Nonnull;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.GuiToast;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.multiplayer.ClientAdvancementManager;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

public class ClientAdvancements {
    public static boolean refreshOnFirstOpen = true;

    public static void setDoneAdvancements(boolean showToast, boolean reset) {
        ClientAdvancements.updateLockStatus(reset);
        if (showToast && !PatchouliConfig.disableAdvancementLocking) {
            BookRegistry.INSTANCE.books.values().forEach(b -> {
                if (b.popUpdated() && b.showToasts) {
                    ClientAdvancements.sendBookToast(b);
                }
            });
        }
    }

    public static void updateLockStatus(boolean reset) {
        ClientBookRegistry.INSTANCE.reloadLocks(reset);
    }

    public static boolean hasDone(String advancement) {
        ClientAdvancementManager manager;
        Advancement adv;
        ResourceLocation id = new ResourceLocation(advancement);
        NetHandlerPlayClient conn = Minecraft.func_71410_x().func_147114_u();
        if (conn != null && (adv = (manager = conn.func_191982_f()).func_194229_a().func_192084_a(id)) != null) {
            AdvancementProgress progress = ClientAdvancements.getProgress(manager, adv);
            return progress != null && progress.func_192105_a();
        }
        return false;
    }

    private static AdvancementProgress getProgress(ClientAdvancementManager manager, Advancement advancement) {
        return (AdvancementProgress)manager.field_192803_d.get(advancement);
    }

    @SubscribeEvent
    public static void onLogout(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        ClientAdvancements.updateLockStatus(true);
        refreshOnFirstOpen = true;
    }

    private static void sendBookToast(Book book) {
        GuiToast toastGui = Minecraft.func_71410_x().func_193033_an();
        LexiconToast toast = (LexiconToast)toastGui.func_192990_a(LexiconToast.class, (Object)book);
        if (toast == null) {
            toastGui.func_192988_a((IToast)new LexiconToast(book));
        }
    }

    public static class LexiconToast
    implements IToast {
        private final Book book;

        public LexiconToast(Book book) {
            this.book = book;
        }

        @Nonnull
        public Book getType() {
            return this.book;
        }

        @Nonnull
        public IToast.Visibility func_193653_a(@Nonnull GuiToast toastGui, long delta) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_110434_K().func_110577_a(field_193654_a);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            toastGui.func_73729_b(0, 0, 0, 32, 160, 32);
            toastGui.func_192989_b().field_71466_p.func_78276_b(I18n.func_135052_a((String)this.book.name, (Object[])new Object[0]), 30, 7, -11534256);
            toastGui.func_192989_b().field_71466_p.func_78276_b(I18n.func_135052_a((String)"patchouli.gui.lexicon.toast.info", (Object[])new Object[0]), 30, 17, -16777216);
            RenderHelper.func_74520_c();
            toastGui.func_192989_b().func_175599_af().func_184391_a(null, this.book.getBookItem(), 8, 8);
            return delta >= 5000L ? IToast.Visibility.HIDE : IToast.Visibility.SHOW;
        }
    }
}

