/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.transformers;

import com.endertech.minecraft.forge.coremod.InstructList;
import com.endertech.minecraft.forge.coremod.descriptors.ClassDescriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Descriptor;
import com.endertech.minecraft.forge.coremod.descriptors.MethodDescriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Types;
import com.endertech.minecraft.forge.coremod.signatures.FieldSignature;
import com.endertech.minecraft.forge.coremod.signatures.MethodSignature;
import com.endertech.minecraft.mods.adpother.transformers.Abstract;
import com.endertech.minecraft.mods.adpother.transformers.Handlers;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;

public class MekanismGenerators {

    public static class GasGenerator
    extends AbstractGenerator {
        private final ClassDescriptor gas = ClassDescriptor.from((String)"mekanism/api/gas/Gas");
        private final ClassDescriptor gasStack = ClassDescriptor.from((String)"mekanism/api/gas/GasStack");
        private final ClassDescriptor gasTank = ClassDescriptor.from((String)"mekanism/api/gas/GasTank");
        private final MethodSignature targetNode;
        private final MethodSignature getFluid;
        private final MethodSignature getStored;
        private final MethodSignature getGas;
        private final FieldSignature amount;

        public GasGenerator() {
            this.targetNode = MethodSignature.of((String)this.gasTank.name.normal, (String)"setGas", (MethodDescriptor)MethodDescriptor.VOID.withParameters(new Descriptor[]{this.gasStack}));
            this.getFluid = MethodSignature.of((String)this.gas.name.normal, (String)"getFluid", (MethodDescriptor)MethodDescriptor.of((Descriptor)Handlers.FLUID_CLASS_DESCRIPTOR));
            this.getStored = MethodSignature.of((String)this.gasTank.name.normal, (String)"getStored", (MethodDescriptor)MethodDescriptor.of((Types)Types.INT));
            this.getGas = MethodSignature.of((String)this.gasStack.name.normal, (String)"getGas", (MethodDescriptor)MethodDescriptor.of((Descriptor)this.gas));
            this.amount = FieldSignature.of((String)this.gasStack.name.normal, (String)"amount", (Descriptor)Types.INT.descriptor);
        }

        @Override
        protected String getClassName() {
            return "mekanism/generators/common/tile/TileEntityGasGenerator";
        }

        @Override
        protected boolean isProperInstruction(MethodInsnNode node) {
            return this.targetNode.complyWith(node);
        }

        @Override
        protected MethodSignature getHandler() {
            return Handlers.ON_FLUID_FUEL_BURNED_BY_TILE_AMOUNT;
        }

        @Override
        protected void injectInstructions(InstructList instructions) {
            instructions.loadThis().dupValue3().invokeVirtual(this.getStored).dupValue3().getField(this.amount).add((AbstractInsnNode)new InsnNode(100)).dupValue3().invokeVirtual(this.getGas).invokeVirtual(this.getFluid).swap().invokeStatic(this.getHandler()).insertBefore();
        }
    }

    public static class HeatGenerator
    extends AbstractGenerator {
        @Override
        protected String getClassName() {
            return "mekanism/generators/common/tile/TileEntityHeatGenerator";
        }
    }

    public static class BioGenerator
    extends AbstractGenerator {
        @Override
        protected String getClassName() {
            return "mekanism/generators/common/tile/TileEntityBioGenerator";
        }
    }

    private static abstract class AbstractGenerator
    extends Abstract.SolidFuelMachine {
        private final MethodSignature target = MethodSignature.of((String)this.getClassName(), (String)"onUpdate", (MethodDescriptor)MethodDescriptor.VOID);

        private AbstractGenerator() {
        }

        protected abstract String getClassName();

        protected MethodSignature getTargetMethod() {
            return this.target;
        }
    }
}

