/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.transformers;

import com.endertech.minecraft.forge.coremod.InstructList;
import com.endertech.minecraft.forge.coremod.descriptors.ClassDescriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Classes;
import com.endertech.minecraft.forge.coremod.descriptors.Descriptor;
import com.endertech.minecraft.forge.coremod.descriptors.MethodDescriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Types;
import com.endertech.minecraft.forge.coremod.names.ClassName;
import com.endertech.minecraft.forge.coremod.signatures.FieldSignature;
import com.endertech.minecraft.forge.coremod.signatures.MethodSignature;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.endertech.minecraft.mods.adpother.transformers.Abstract;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import org.objectweb.asm.tree.MethodInsnNode;

public class IndustrialRenewal {

    public static class FluidGenerator
    extends Abstract.LiquidFuelMachine {
        private final String className = "cassiokf.industrialrenewal.handlers.FluidGenerator";
        private final MethodSignature targetMethod = MethodSignature.of((String)"cassiokf.industrialrenewal.handlers.FluidGenerator", (String)"updateLiquidFuel", (MethodDescriptor)MethodDescriptor.VOID);
        private final MethodSignature targetInstruct;
        private final FieldSignature attachedTE;

        public FluidGenerator() {
            this.targetInstruct = MethodSignature.of((ClassName)Classes.FLUID_TANK.name, (String)"drainInternal", (MethodDescriptor)MethodDescriptor.of((Classes)Classes.FLUID_STACK).withParameters(new Types[]{Types.INT, Types.BOOLEAN}));
            this.attachedTE = FieldSignature.of((String)"cassiokf.industrialrenewal.handlers.FluidGenerator", (String)"attachedTE", (Descriptor)ClassDescriptor.from((String)"cassiokf/industrialrenewal/tileentity/abstracts/TileEntitySync"));
        }

        protected MethodSignature getTargetMethod() {
            return this.targetMethod;
        }

        @Override
        protected boolean isProperInstruction(MethodInsnNode instruct) {
            return this.targetInstruct.complyWith(instruct);
        }

        @Override
        protected void injectInstructions(InstructList instructions) {
            instructions.dup().loadThis().getField(this.attachedTE).swap().invokeStatic(this.getHandler()).insertAfter();
        }
    }

    public static class SteamBoiler {
        private static final String CLASS_NAME = "cassiokf.industrialrenewal.handlers.SteamBoiler";
        private static final FieldSignature TIED_TE = FieldSignature.of((String)"cassiokf.industrialrenewal.handlers.SteamBoiler", (String)"tiedTE", (Descriptor)ClassDescriptor.from((String)"cassiokf/industrialrenewal/util/interfaces/ISync"));

        public static class LiquidFuel
        extends Abstract.LiquidFuelMachine {
            private final MethodSignature targetMethod;
            private final MethodSignature targetInstruct;

            public LiquidFuel() {
                this.targetMethod = MethodSignature.of((String)SteamBoiler.CLASS_NAME, (String)"updateLiquidFuel", (MethodDescriptor)MethodDescriptor.of((Types)Types.INT).withParameters(new Descriptor[]{Classes.FLUID_STACK.descriptor, Types.BOOLEAN.descriptor}));
                this.targetInstruct = MethodSignature.of((ClassName)Classes.FLUID_STACK.name, (String)"getLocalizedName", (MethodDescriptor)MethodDescriptor.of((Descriptor)ClassDescriptor.from((String)"java.lang.String")));
            }

            public static void handle(Object tiedTE, FluidStack stack, int amount) {
                if (tiedTE instanceof Entity) {
                    Entity entity = (Entity)tiedTE;
                    BlockPos pos = ForgeEntity.getCenterPosition((Entity)entity).toBlockPos();
                    WorldData.onFuelBurned(entity.field_70170_p, pos, stack.getFluid(), amount);
                } else if (tiedTE instanceof TileEntity) {
                    TileEntity tile = (TileEntity)tiedTE;
                    WorldData.onFuelBurned(tile, stack, amount);
                }
            }

            protected MethodSignature getTargetMethod() {
                return this.targetMethod;
            }

            @Override
            protected MethodSignature getHandler() {
                return this.getDefaultHandlerWith(MethodDescriptor.VOID.withParameters(new Descriptor[]{Classes.OBJECT.descriptor, Classes.FLUID_STACK.descriptor, Types.INT.descriptor}));
            }

            @Override
            protected boolean isProperInstruction(MethodInsnNode instruct) {
                return this.targetInstruct.complyWith(instruct);
            }

            @Override
            protected void injectInstructions(InstructList instructions) {
                instructions.dup().loadThis().getField(TIED_TE).swap().loadIntFrom(4, "amount").invokeStatic(this.getHandler()).insertBefore();
            }
        }

        public static class SolidFuel
        extends Abstract.SolidFuelMachine {
            private final MethodSignature targetMethod;

            public SolidFuel() {
                this.targetMethod = MethodSignature.of((String)SteamBoiler.CLASS_NAME, (String)"updateSolidFuel", (MethodDescriptor)MethodDescriptor.of((Classes)Classes.ITEM_STACK).withParameters(new Descriptor[]{Classes.ITEM_STACK.descriptor, Types.BOOLEAN.descriptor}));
            }

            public static void handle(Object tiedTE, ItemStack stack) {
                if (tiedTE instanceof Entity) {
                    Entity entity = (Entity)tiedTE;
                    BlockPos pos = ForgeEntity.getCenterPosition((Entity)entity).toBlockPos();
                    WorldData.onFuelBurned(entity.field_70170_p, pos, stack, 1);
                } else if (tiedTE instanceof TileEntity) {
                    TileEntity tile = (TileEntity)tiedTE;
                    WorldData.onFuelBurned(tile, stack);
                }
            }

            protected MethodSignature getTargetMethod() {
                return this.targetMethod;
            }

            @Override
            protected MethodSignature getHandler() {
                return this.getDefaultHandlerWith(MethodDescriptor.VOID.withParameters(new Classes[]{Classes.OBJECT, Classes.ITEM_STACK}));
            }

            @Override
            protected void injectInstructions(InstructList instructions) {
                instructions.loadThis().getField(TIED_TE).dupValue3().invokeStatic(this.getHandler()).insertBefore();
            }
        }
    }
}

