/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.transformers;

import com.endertech.minecraft.forge.coremod.ForgeClassTransformer;
import com.endertech.minecraft.forge.coremod.InstructList;
import com.endertech.minecraft.forge.coremod.descriptors.ArrayDescriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Classes;
import com.endertech.minecraft.forge.coremod.descriptors.Descriptor;
import com.endertech.minecraft.forge.coremod.descriptors.MethodDescriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Types;
import com.endertech.minecraft.forge.coremod.signatures.FieldSignature;
import com.endertech.minecraft.forge.coremod.signatures.MethodSignature;
import com.endertech.minecraft.mods.adpother.transformers.Handlers;
import org.objectweb.asm.tree.MethodInsnNode;

public class ImmersiveEngineering {

    public static class DieselGenerator
    extends AbstractTile {
        private final FieldSignature tanks;

        public DieselGenerator() {
            this.tanks = FieldSignature.of((String)this.getTargetMethod().className.normal, (String)"tanks", (Descriptor)ArrayDescriptor.of((Classes)Classes.FLUID_TANK));
        }

        @Override
        protected String getClassName() {
            return "blusunrize.immersiveengineering.common.blocks.metal.TileEntityDieselGenerator";
        }

        protected boolean isProperInstruction(MethodInsnNode node) {
            return MethodSignature.FLUID_TANK_DRAIN.complyWith(node);
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.forceNormalNames().loadThis().getField(this.tanks).loadFromArray(0).invokeVirtual(MethodSignature.FLUID_TANK_GET_FLUID).loadThis().swap().loadIntFrom(3, "fluidConsumed").invokeStatic(this.getHandler()).insertBefore();
        }

        @Override
        protected MethodSignature getHandler() {
            return Handlers.ON_FLUID_FUEL_STACK_BURNED_BY_TILE_AMOUNT;
        }
    }

    public static class BlastFurnace
    extends AbstractTile {
        private final MethodSignature targetNode = MethodSignature.of((String)"blusunrize/immersiveengineering/api/crafting/BlastFurnaceRecipe", (String)"getBlastFuelTime", (MethodDescriptor)MethodDescriptor.of((Types)Types.INT).withParameters(new Classes[]{Classes.ITEM_STACK}));

        @Override
        protected String getClassName() {
            return "blusunrize.immersiveengineering.common.blocks.stone.TileEntityBlastFurnace";
        }

        protected boolean isProperInstruction(MethodInsnNode node) {
            return this.targetNode.complyWith(node);
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.loadThis().loadThis().getField(this.inventory).pushInt(1).invokeVirtual(MethodSignature.NON_NULL_LIST_GET).checkCast(Classes.ITEM_STACK.name).invokeStatic(this.getHandler()).insertAfter();
        }
    }

    public static class CokeOven
    extends AbstractTile {
        private final MethodSignature targetNode;

        public CokeOven() {
            this.targetNode = MethodSignature.of((String)"blusunrize/immersiveengineering/common/util/Utils", (String)"modifyInvStackSize", (MethodDescriptor)MethodDescriptor.VOID.withParameters(new Descriptor[]{Classes.NON_NULL_LIST.descriptor, Types.INT.descriptor, Types.INT.descriptor}));
        }

        @Override
        protected String getClassName() {
            return "blusunrize.immersiveengineering.common.blocks.stone.TileEntityCokeOven";
        }

        protected boolean isProperInstruction(MethodInsnNode node) {
            return this.targetNode.complyWith(node);
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.loadThis().getField(this.inventory).pushInt(0).invokeVirtual(MethodSignature.NON_NULL_LIST_GET).checkCast(Classes.ITEM_STACK.name).loadThis().swap().invokeStatic(this.getHandler()).insertBefore();
        }
    }

    public static class AllowSmelter
    extends AbstractTile {
        @Override
        protected String getClassName() {
            return "blusunrize.immersiveengineering.common.blocks.stone.TileEntityAlloySmelter";
        }

        protected boolean isProperInstruction(MethodInsnNode node) {
            return MethodSignature.ITEM_STACK_SHRINK.complyWith(node);
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.loadThis().dupValue3().invokeStatic(this.getHandler()).insertBefore();
        }
    }

    private static abstract class AbstractTile
    extends ForgeClassTransformer {
        private final MethodSignature targetMethod = MethodSignature.I_TICKABLE_UPDATE.with(this.getClassName());
        protected final FieldSignature inventory;

        private AbstractTile() {
            this.inventory = FieldSignature.of((String)this.getTargetMethod().className.normal, (String)"inventory", (Descriptor)Classes.NON_NULL_LIST.descriptor);
        }

        protected abstract String getClassName();

        protected MethodSignature getTargetMethod() {
            return this.targetMethod;
        }

        public boolean isCompatibilityMode() {
            return true;
        }

        protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperNode) {
            return false;
        }

        protected MethodSignature getHandler() {
            return Handlers.ON_FUEL_BURNED_BY_TILE;
        }
    }
}

