/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.transformers;

import com.endertech.minecraft.forge.coremod.ForgeClassTransformer;
import com.endertech.minecraft.forge.coremod.InstructList;
import com.endertech.minecraft.forge.coremod.descriptors.Classes;
import com.endertech.minecraft.forge.coremod.descriptors.Descriptor;
import com.endertech.minecraft.forge.coremod.descriptors.MethodDescriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Types;
import com.endertech.minecraft.forge.coremod.names.ClassName;
import com.endertech.minecraft.forge.coremod.signatures.MethodSignature;
import com.endertech.minecraft.mods.adpother.transformers.Handlers;
import org.objectweb.asm.tree.MethodInsnNode;

public class FastFurnace {
    private static final String CLASS_NAME = "shadows.fastfurnace.block.TileFastFurnace";

    public static class Burning
    extends ForgeClassTransformer {
        private final MethodSignature targetMethod;

        public Burning() {
            this.targetMethod = MethodSignature.of((String)FastFurnace.CLASS_NAME, (String)"burnFuel", (MethodDescriptor)MethodDescriptor.VOID.withParameters(new Descriptor[]{Classes.ITEM_STACK.descriptor, Types.BOOLEAN.descriptor}));
        }

        protected MethodSignature getTargetMethod() {
            return this.targetMethod;
        }

        protected MethodSignature getHandler() {
            return Handlers.ON_FUEL_BURNED_BY_TILE;
        }

        protected boolean isProperInstruction(MethodInsnNode instruct) {
            return MethodSignature.ITEM_STACK_SHRINK.complyWith(instruct);
        }

        protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperInstruct) {
            return false;
        }

        protected void injectInstructions(InstructList instructions) {
            InstructList.VarNode fuel = InstructList.createObjVar((String)"fuel", (int)1);
            instructions.loadThis().loadVar(fuel).invokeStatic(this.getHandler()).insertBefore();
        }

        public boolean isCompatibilityMode() {
            return true;
        }
    }

    public static class Smelting
    extends ForgeClassTransformer {
        private final MethodSignature targetMethod = MethodSignature.of((ClassName)ClassName.from((String)"shadows.fastfurnace.block.TileFastFurnace"), (String)"smeltItem", (String)"func_145949_j", (MethodDescriptor)MethodDescriptor.VOID);

        protected MethodSignature getTargetMethod() {
            return this.targetMethod;
        }

        protected MethodSignature getHandler() {
            return Handlers.ON_FUEL_BURNED_BY_TILE;
        }

        protected boolean isProperInstruction(MethodInsnNode instruct) {
            return MethodSignature.ITEM_STACK_SHRINK.complyWith(instruct);
        }

        protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperInstruct) {
            return false;
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.swap().dup().loadThis().swap().invokeStatic(this.getHandler()).swap().insertBefore();
        }

        public boolean isCompatibilityMode() {
            return true;
        }
    }
}

