/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.transformers;

import com.endertech.minecraft.forge.coremod.ForgeClassTransformer;
import com.endertech.minecraft.forge.coremod.InstructList;
import com.endertech.minecraft.forge.coremod.descriptors.ClassDescriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Classes;
import com.endertech.minecraft.forge.coremod.descriptors.Descriptor;
import com.endertech.minecraft.forge.coremod.descriptors.MethodDescriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Types;
import com.endertech.minecraft.forge.coremod.names.ClassName;
import com.endertech.minecraft.forge.coremod.signatures.MethodSignature;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.world.WorldBounds;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.objectweb.asm.tree.MethodInsnNode;

public class AdvancedRocketry {

    public static class Rocket
    extends ForgeClassTransformer {
        private final String className = "zmaster587.advancedRocketry.entity.EntityRocket";
        private final ClassName fuelType = ClassName.from((String)"zmaster587/advancedRocketry/api/fuel/FuelRegistry$FuelType");
        private final ClassDescriptor descString = ClassDescriptor.from((String)"java/lang/String");
        private final MethodSignature targetMethod = MethodSignature.ENTITY_ON_UPDATE.with("zmaster587.advancedRocketry.entity.EntityRocket");
        private final MethodSignature targetNode;
        private final MethodSignature getFuelType;
        private final MethodSignature getFuelName;
        private final MethodSignature getFuelAmount;

        public Rocket() {
            this.targetNode = MethodSignature.of((String)"zmaster587.advancedRocketry.entity.EntityRocket", (String)"setFuelAmount", (MethodDescriptor)MethodDescriptor.VOID.withParameters(new Descriptor[]{ClassDescriptor.from((ClassName)this.fuelType), Types.INT.descriptor}));
            this.getFuelType = MethodSignature.of((String)"zmaster587.advancedRocketry.entity.EntityRocket", (String)"getRocketFuelType", (MethodDescriptor)MethodDescriptor.of((Descriptor)ClassDescriptor.from((ClassName)this.fuelType)));
            this.getFuelName = MethodSignature.of((ClassName)this.fuelType, (String)"name", (MethodDescriptor)MethodDescriptor.of((Descriptor)this.descString));
            this.getFuelAmount = MethodSignature.of((String)"zmaster587.advancedRocketry.entity.EntityRocket", (String)"getFuelConsumptionRate", (MethodDescriptor)MethodDescriptor.of((Types)Types.INT).withParameters(new Descriptor[]{ClassDescriptor.from((ClassName)this.fuelType)}));
        }

        public static void handle(Entity entity, String fuelName, int amount) {
            if (amount <= 0) {
                return;
            }
            if (!fuelName.contains("MONOPROPELLANT")) {
                return;
            }
            Fluid rocketFuel = FluidRegistry.getFluid((String)"rocketfuel");
            AxisAlignedBB aabb = ForgeEntity.getBB((Entity)entity);
            WorldBounds bounds = WorldBounds.from((BlockPos)new BlockPos(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c), (BlockPos)new BlockPos(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f)).extend(1);
            BlockPos pos = new BlockPos(bounds.getX().randomBetween().intValue(), bounds.getY().randomBetween().intValue(), bounds.getZ().randomBetween().intValue());
            WorldData.onFuelBurned(entity, pos, rocketFuel, amount);
        }

        public boolean isCompatibilityMode() {
            return true;
        }

        protected MethodSignature getTargetMethod() {
            return this.targetMethod;
        }

        protected MethodSignature getHandler() {
            return this.getDefaultHandlerWith(MethodDescriptor.VOID.withParameters(new Descriptor[]{Classes.ENTITY.descriptor, this.descString, Types.INT.descriptor}));
        }

        protected boolean isProperInstruction(MethodInsnNode instruct) {
            return this.targetNode.complyWith(instruct);
        }

        protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperInstruct) {
            return false;
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.loadThis().loadThis().invokeVirtual(this.getFuelType).invokeVirtual(this.getFuelName).loadThis().loadThis().invokeVirtual(this.getFuelType).invokeVirtual(this.getFuelAmount).invokeStatic(this.getHandler()).insertAfter();
        }
    }
}

