/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Spread {
    public static final int ANY_DENSITY_DELTA = Integer.MIN_VALUE;
    private final Pollutant<?> pollutant;
    private final World world;
    private final BlockPos sourcePos;
    @Nullable
    private BlockPos targetPos;
    private IBlockState sourceState;
    @Nullable
    private IBlockState targetState;
    private boolean sourceChanged = false;
    private boolean targetChanged = false;
    private final Optional<EnumFacing> motionFacing;

    public static Spread from(World world, BlockPos pos, IBlockState state, Pollutant<?> pollutant) {
        return new Spread(world, pos, state, pollutant);
    }

    protected Spread(World world, BlockPos pos, IBlockState state, Pollutant<?> pollutant) {
        this.pollutant = pollutant;
        this.world = world;
        this.sourcePos = pos;
        this.sourceState = state;
        this.motionFacing = pollutant.getMotionFacing(world, pos);
    }

    @Nullable
    public IBlockState getTargetState() {
        return this.targetState;
    }

    @Nullable
    public BlockPos getTargetPos() {
        return this.targetPos;
    }

    protected void setTargetPos(BlockPos targetPos) {
        this.targetPos = targetPos;
    }

    protected void setTarget(IBlockState target) {
        if (this.targetState != target) {
            this.targetState = target;
            this.targetChanged = true;
        }
    }

    public IBlockState getSourceState() {
        return this.sourceState;
    }

    public void setSource(IBlockState source) {
        if (this.sourceState != source) {
            this.sourceState = source;
            this.sourceChanged = true;
        }
    }

    public boolean sourceChanged() {
        return this.sourceChanged;
    }

    public boolean targetChanged() {
        return this.targetChanged;
    }

    public Pollutant<?> getPollutant() {
        return this.pollutant;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getSourcePos() {
        return this.sourcePos;
    }

    public Spread around(int minDensityDelta) {
        block1: {
            EnumFacing facing;
            if (this.completed() || !this.pollutant.canSpreadAround() || this.pollutant.getCarriedPollutionAmount(this.getSourceState()) < minDensityDelta) break block1;
            Iterator iterator = ForgeWorld.Direction.getShuffledHorizontals().iterator();
            while (iterator.hasNext() && !this.in(facing = (EnumFacing)iterator.next(), minDensityDelta).completed()) {
            }
        }
        return this;
    }

    public Spread in(Optional<EnumFacing> direction, int minDensityDelta) {
        return !this.completed() && direction.isPresent() ? this.in(direction.get(), minDensityDelta) : this;
    }

    public Spread in(EnumFacing direction, int minDensityDelta) {
        if (this.completed() || this.world.isSideSolid(this.sourcePos, direction)) {
            return this;
        }
        BlockPos destPos = this.sourcePos.func_177972_a(direction);
        if (this.to(destPos, minDensityDelta).completed()) {
            return this;
        }
        if (this.pollutant.canPassThrough(this.world, destPos, direction.func_176734_d(), direction)) {
            return this.to(destPos.func_177972_a(direction), minDensityDelta);
        }
        return this;
    }

    public Spread inMotionFacing() {
        return this.in(this.motionFacing, 0);
    }

    public Spread to(BlockPos targetPos, int minDensityDelta) {
        if (!this.completed() && this.pollutant.getAltitudeBounds().encloses(Integer.valueOf(targetPos.func_177956_o()))) {
            int pollutionDelta;
            IBlockState sourceState = this.getSourceState();
            IBlockState targetState = this.world.func_180495_p(targetPos);
            while (this.pollutant.canStateBeSpreaded(sourceState) && this.pollutant.canStateBePumped(targetState) && (pollutionDelta = this.pollutant.getCarriedPollutionAmount(sourceState) - this.pollutant.getCarriedPollutionAmount(targetState)) >= minDensityDelta) {
                sourceState = this.pollutant.getSpreadedState(sourceState);
                this.setSource(sourceState);
                this.setTargetPos(targetPos);
                targetState = this.pollutant.getPumpedState(targetState);
                this.setTarget(targetState);
            }
        }
        return this;
    }

    public Spread overLedge() {
        if (!this.completed() && this.pollutant.canSpreadOverLedge() && this.motionFacing.isPresent()) {
            int minDelta;
            BlockPos ledgePos = this.sourcePos.func_177972_a(this.motionFacing.get());
            int n = minDelta = this.pollutant.isSamePollutant(this.world.func_180495_p(ledgePos)) ? 0 : -1;
            if (this.pollutant.getAltitudeBounds().encloses(Integer.valueOf(ledgePos.func_177956_o()))) {
                for (EnumFacing facing : ForgeWorld.Direction.getShuffledHorizontals()) {
                    BlockPos targetPos;
                    BlockPos checkPos = this.sourcePos.func_177972_a(facing);
                    if (this.world.isSideSolid(this.sourcePos, facing) || !this.pollutant.canPassThrough(this.world, checkPos, facing.func_176734_d(), this.motionFacing.get()) || !this.to(targetPos = ledgePos.func_177972_a(facing), minDelta).completed()) continue;
                    break;
                }
            }
        }
        return this;
    }

    public boolean isValid() {
        return this.completed() && this.getTargetPos() != null && this.getTargetState() != null && !this.world.field_72995_K;
    }

    public boolean completed() {
        return this.sourceChanged && this.targetChanged;
    }

    protected void apply(BlockPos pos, IBlockState state) {
        this.world.func_175656_a(pos, state);
        if (!ForgeWorld.isAirBlock((IBlockState)state)) {
            this.pollutant.scheduleUpdate(this.world, pos);
        }
    }

    public void applyTarget() {
        if (this.isValid()) {
            this.apply(this.getTargetPos(), this.getTargetState());
        }
    }

    public void applySource() {
        if (this.isValid()) {
            this.apply(this.getSourcePos(), this.getSourceState());
        }
    }

    public void apply() {
        this.applySource();
        this.applyTarget();
    }
}

