/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.Args;
import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.forge.world.ChunkLoc;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.emissions.Emission;
import com.endertech.minecraft.mods.adpother.entities.EntityPollutant;
import com.endertech.minecraft.mods.adpother.pollution.AbstractPollution;
import com.endertech.minecraft.mods.adpother.pollution.PollutionInfo;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.Fuel;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.util.INBTSerializable;

public class ChunkPollution
extends AbstractPollution {
    private final ChunkLoc location;
    private boolean unloaded = false;

    public ChunkPollution(ChunkLoc location) {
        this.location = location;
    }

    public void increaseBy(Emitter emitter, Fuel fuel, int amount, TileEntity tile) {
        World world = tile.func_145831_w();
        if (!ForgeWorld.isServerSide((World)world)) {
            return;
        }
        Biome biome = world.func_180494_b(tile.func_174877_v());
        for (Pollutant<?> pollutant : fuel.getPollutants()) {
            if (!pollutant.inAllowableDimension(world)) continue;
            float biomeRate = pollutant.getEmissionRateIn(biome);
            float emitterRate = emitter.getFuelConsumptionRate((INBTSerializable<NBTTagCompound>)tile);
            double totalAmount = fuel.getEmissionOf(pollutant) * (float)amount * biomeRate * emitterRate * Emission.globalRate;
            int intAmount = this.getIntAndUpdateFractAmount(pollutant, totalAmount);
            if (intAmount <= 0) continue;
            WorldData.scheduleEmissionFor(tile, emitter.getRelatedBlocks(), pollutant, intAmount);
        }
    }

    public void increaseBy(SourceBase source, float factor, World world, BlockPos pos) {
        if (!ForgeWorld.isServerSide((World)world)) {
            return;
        }
        Biome biome = world.func_180494_b(pos);
        for (Pollutant<?> pollutant : source.getPollutants()) {
            if (!pollutant.inAllowableDimension(world)) continue;
            float biomeRate = pollutant.getEmissionRateIn(biome);
            double totalAmount = factor * source.getEmissionOf(pollutant) * biomeRate * Emission.globalRate;
            int intAmount = this.getIntAndUpdateFractAmount(pollutant, totalAmount);
            if (intAmount > 0 && source instanceof Emitter) {
                TileEntity tile;
                Emitter emitter = (Emitter)source;
                TileEntity tileEntity = tile = emitter.isEntity() ? null : world.func_175625_s(pos);
                if (tile != null) {
                    WorldData.scheduleEmissionFor(tile, emitter.getRelatedBlocks(), pollutant, intAmount);
                    continue;
                }
            }
            pollutant.generateAt(world, pos, intAmount, 1);
        }
    }

    protected int getIntAndUpdateFractAmount(Pollutant<?> pollutant, double amount) {
        if (CommonMath.notZero((double)amount)) {
            PollutionInfo info = this.getOrCreateInfoFor(pollutant);
            double fractAmount = info.getFractAmount() + amount;
            int intAmount = MathHelper.func_76128_c((double)fractAmount);
            info.setFractAmount(fractAmount -= (double)intAmount);
            return intAmount;
        }
        return 0;
    }

    protected void increaseBy(World world, BlockPos pos, IBlockState state, int blocksAmount) {
        Pollutant pollutant;
        if (state != null && state.func_177230_c() instanceof Pollutant && (pollutant = (Pollutant)state.func_177230_c()).affectsPollutionLevel(world, pos, state)) {
            int amount = pollutant.getCarriedPollutionAmount(state) * blocksAmount;
            this.increaseBy(world, pollutant, amount);
        }
    }

    protected void increaseBy(World world, Pollutant<?> pollutant, int amount) {
        if (amount != 0) {
            PollutionInfo info = this.getOrCreateInfoFor(pollutant);
            info.increaseAmount(amount);
        }
    }

    public ChunkLoc getLocation() {
        return this.location;
    }

    public void clean(World world) {
        ChunkBounds bounds = this.getLocation().getBounds();
        int x = bounds.getX().getMin();
        while (bounds.getX().encloses(Integer.valueOf(x))) {
            int z = bounds.getZ().getMin();
            while (bounds.getZ().encloses(Integer.valueOf(z))) {
                int y = bounds.getY().getMin();
                while (bounds.getY().encloses(Integer.valueOf(y))) {
                    BlockPos pos = new BlockPos(x, y, z);
                    Block block = world.func_180495_p(pos).func_177230_c();
                    if (block instanceof Pollutant) {
                        world.func_175698_g(pos);
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
        ChunkPos chunkPos = this.getLocation().getPos();
        for (ClassInheritanceMultiMap entityList : world.func_72964_e(chunkPos.field_77276_a, chunkPos.field_77275_b).func_177429_s()) {
            for (Entity entity : entityList) {
                if (!(entity instanceof EntityPollutant)) continue;
                entity.func_70106_y();
            }
        }
        this.infoForPollutant.clear();
    }

    public void recalculate(World world) {
        this.getInfos().forEach(info -> info.setAmount(0));
        ChunkBounds bounds = this.getLocation().getBounds();
        bounds.forEach(pos -> {
            Pollutant pollutant;
            IBlockState state = world.func_180495_p((BlockPos)pos);
            if (state.func_177230_c() instanceof Pollutant && (pollutant = (Pollutant)state.func_177230_c()).affectsPollutionLevel(world, (BlockPos)pos, state)) {
                int amount = pollutant.getCarriedPollutionAmount(state);
                this.getOrCreateInfoFor(pollutant).increaseAmount(amount);
            }
        });
    }

    public boolean isUnloaded() {
        return this.unloaded;
    }

    public void setUnloaded(boolean value) {
        this.unloaded = value;
    }

    public String toString() {
        return this.getClass().getSimpleName() + Args.group((Object[])new Object[]{this.getInfos(), Args.get((String)"location", (Object)this.getLocation())});
    }
}

