/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.init;

import com.endertech.common.CommonTime;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.entities.ForgePotion;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.units.RelatedUnit;
import com.endertech.minecraft.forge.units.RelatedUnitsInit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.init.Pollutants;
import com.endertech.minecraft.mods.adpother.pollution.IStorage;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import org.apache.commons.lang3.tuple.Pair;

public class Respirators
extends RelatedUnitsInit<Respirator, BuiltIn> {
    private final RespiratorEffect effect;

    public Respirators(ForgeMod mod) {
        super(mod, BuiltIn.class);
        this.effect = new RespiratorEffect(mod);
    }

    public Respirator createCustomUnitFrom(UnitConfig config, String name) {
        return new Respirator(config, UnitId.EMPTY, 0, "");
    }

    public Respirator createDefaultUnitFrom(UnitConfig config, BuiltIn e) {
        return e.createRespirator(config, UnitId.from((Enum)e, (boolean)true));
    }

    public RespiratorEffect getEffect() {
        return this.effect;
    }

    public CommonTime.Interval getEffectDurationFor(Respirator respirator, ItemStack stack, int damage) {
        if (damage > 0) {
            IStorage.Content content = respirator.getContent(stack);
            double seconds = content.hasFunctionalFilters() ? (double)(content.getCapacity() - content.getHighestFullness()) : 0.0;
            seconds /= (double)damage;
            seconds = Math.max(2.0, seconds);
            return CommonTime.Interval.seconds((double)seconds);
        }
        return CommonTime.Interval.hours((double)1.0);
    }

    public Optional<Pair<ItemStack, Respirator>> findOn(EntityLivingBase living, boolean onlyFunctional) {
        for (ItemStack stack : ForgeEntity.getEquipmentOn((Entity)living)) {
            Respirator respirator = (Respirator)this.findBy(stack);
            if (respirator == null || onlyFunctional && !respirator.isFunctional(stack)) continue;
            return Optional.of(Pair.of((Object)stack, (Object)respirator));
        }
        return Optional.empty();
    }

    public void updateEffectFor(EntityLivingBase living, int damage) {
        living.func_184589_d((Potion)this.getEffect());
        this.findOn(living, true).ifPresent(pair -> {
            CommonTime.Interval duration = this.getEffectDurationFor((Respirator)pair.getRight(), (ItemStack)pair.getLeft(), damage);
            living.func_70690_d(this.getEffect().createEffect(duration, false));
        });
    }

    public static class Respirator
    extends RelatedUnit
    implements IStorageItem {
        public final int durability;
        protected final boolean allowsEating;
        private final String functionalStateTag;

        public Respirator(UnitConfig config, UnitId id, int durability, String functionalStateTag) {
            super(config, id);
            String category = this.getClassCategory();
            this.durability = ForgeConfig.getInt((ForgeConfig)config, (String)category, (String)"durability", (int)durability, (IntBounds)ForgeBounds.DURABILITY.getIntBounds(), (String)"How long (in seconds) this respirator can withstand low-level pollution.");
            this.allowsEating = ForgeConfig.getBool((ForgeConfig)config, (String)category, (String)"allowsEating", (boolean)false, (String)"Whether or not eating and drinking are allowed while wearing this respirator.");
            this.functionalStateTag = ForgeConfig.getStr((ForgeConfig)config, (String)category, (String)"functionalStateTag", (String)functionalStateTag, (String)"The name of the NBT tag that stores info about the active state.\nRespirator is considered functional only if the returning value is > 0 or true.\nSet empty string for no checks");
            this.saveConfig();
        }

        public static void setAllowsEatingTag(ItemStack stack, boolean value) {
            ForgeItem.ensureHasNBT((ItemStack)stack);
            stack.func_77978_p().func_74757_a("allowsEating", true);
        }

        public boolean isFunctional(ItemStack stack) {
            int value;
            NBTTagCompound compound;
            if (ForgeItem.isBroken((ItemStack)stack)) {
                return false;
            }
            if (!this.functionalStateTag.isEmpty() && (compound = stack.func_77978_p()) != null && (value = compound.func_74762_e(this.functionalStateTag)) <= 0) {
                return false;
            }
            return this.getContent(stack).hasFunctionalFilters();
        }

        public boolean allowsEating(ItemStack stack) {
            if (this.allowsEating) {
                return true;
            }
            NBTTagCompound compound = stack.func_77978_p();
            return compound != null && compound.func_74767_n("allowsEating");
        }

        public String getTagName() {
            return this.functionalStateTag;
        }

        @Override
        public int getInitialCapacity(ItemStack storage) {
            return this.durability;
        }
    }

    public static class RespiratorEffect
    extends ForgePotion {
        protected RespiratorEffect(ForgeMod mod) {
            super(mod, false, Pollutants.BuiltIn.CARBON.get().getColor());
            this.func_188413_j();
        }

        public void func_76394_a(EntityLivingBase living, int amplifier) {
        }
    }

    static enum BuiltIn implements IForgeEnum
    {
        adpother$iron_respirator(600),
        adpother$gold_respirator(720),
        adpother$diamond_respirator(1440),
        advancedrocketry$spacehelmet(1200),
        ecomod$respirator("filter", 720),
        compositegear$respirator_mask(720),
        compositegear$respirator_mask_composite(1200),
        compositegear$rubber_gasmask(600),
        gases$primitive_respirator(600),
        gases$advanced_respirator(1200),
        gaspunk$gas_mask(720),
        hbm$gas_mask(720),
        hbm$gas_mask_m65(720),
        hbm$hazmat_helmet(600),
        hbm$hazmat_paa_helmet(600),
        hbm$hazmat_helmet_grey(720),
        hbm$hazmat_helmet_red(720),
        hbm$ajr_helmet(1440),
        hbm$hev_helmet(1440),
        ic2$hazmat_helmet(720),
        mekanism$gasmask(720),
        mist$respirator_single(600),
        mw$m40gasmask_helmet(1200),
        nuclearcraft$helm_hazmat(720),
        techguns$gasmask(720),
        techguns$hazmat_helmet(720),
        techguns$steam_helmet(1200),
        techguns$t2_commando_helmet(1200),
        techguns$t3_miner_helmet(2160),
        techguns$t3_power_helmet(2160),
        techguns$t4_praetor_helmet(2880),
        techguns$t4_power_helmet(2880),
        techguns$tacticalmask(2880);

        public final int durability;
        public final String functionalStateTag;

        private BuiltIn(String functionalStateTag, int durability) {
            this.durability = durability;
            this.functionalStateTag = functionalStateTag;
        }

        private BuiltIn(int durability) {
            this("", durability);
        }

        public String func_176610_l() {
            return this.getLowerCase(this.name());
        }

        Respirator createRespirator(UnitConfig config, UnitId id) {
            return new Respirator(config, id, this.durability, this.functionalStateTag);
        }
    }
}

