/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.emissions;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.blocks.BlockState;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.units.StateHashSet;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.emissions.IScheduledEmission;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEmission
implements IScheduledEmission {
    private final TileEntity tile;
    private final GameTime updateInterval;
    protected final Map<Pollutant<?>, Integer> amounts;
    protected final Set<BlockState> relatedBlocks;
    protected boolean exists = true;
    protected int fails = 0;
    protected int emits = 0;

    public TileEmission(TileEntity tile) {
        this.tile = tile;
        this.amounts = new HashMap();
        this.relatedBlocks = new StateHashSet();
        this.updateInterval = GameTime.seconds((int)3);
    }

    public static TileEmission from(TileEntity tile, Set<BlockState> relatedBlocks, Pollutant<?> pollutant, int amount) {
        return new TileEmission(tile).add(relatedBlocks).add(pollutant, amount);
    }

    public TileEmission add(Set<BlockState> relatedBlocks) {
        this.relatedBlocks.addAll(relatedBlocks);
        return this;
    }

    public TileEmission add(Pollutant<?> pollutant, int amount) {
        Integer old = this.getAmountOf(pollutant);
        this.amounts.put(pollutant, old + amount);
        this.checkAmountOf(pollutant);
        return this;
    }

    protected void checkAmountOf(Pollutant<?> pollutant) {
        if (this.getAmountOf(pollutant) <= 0) {
            this.amounts.remove(pollutant);
        }
    }

    public TileEntity getTile() {
        return this.tile;
    }

    public Set<BlockState> getRelatedBlocks() {
        return Collections.unmodifiableSet(this.relatedBlocks);
    }

    public int getAmountOf(Pollutant<?> pollutant) {
        Integer amount = this.amounts.get(pollutant);
        return amount != null ? amount : 0;
    }

    public int emit(Pollutant<?> pollutant, int amount) {
        BlockPos pos = this.getTile().func_174877_v();
        TileEntity tile = this.getWorld().func_175625_s(pos);
        if (!this.getTile().equals(tile) || !this.getWorld().func_175697_a(pos, 1)) {
            this.kill();
            return 0;
        }
        return pollutant.emitFrom(this.getTile(), this.relatedBlocks, amount);
    }

    public World getWorld() {
        return this.getTile().func_145831_w();
    }

    public int getPollutantsNumber() {
        return this.amounts.keySet().size();
    }

    @Nullable
    public Pollutant<?> pickPollutant() {
        int chosen = CommonMath.Random.between((int)0, (int)(this.getPollutantsNumber() - 1));
        int i = 0;
        for (Pollutant<?> pollutant : this.amounts.keySet()) {
            if (i < chosen) {
                ++i;
                continue;
            }
            if (i != chosen) break;
            return pollutant;
        }
        return null;
    }

    @Override
    public void update() {
        if (this.getPollutantsNumber() <= 0) {
            this.kill();
        }
        if (!this.exists()) {
            return;
        }
        if (!this.getUpdateInterval().pastIn(this.getWorld())) {
            return;
        }
        if (this.fails < 0) {
            this.fails = 0;
        }
        World world = this.getWorld();
        Pollutant<?> pollutant = this.pickPollutant();
        if (pollutant == null) {
            this.kill();
            return;
        }
        this.checkAmountOf(pollutant);
        int maxPressure = pollutant.getPollutionCapacity();
        int amount = Math.min(this.getAmountOf(pollutant), maxPressure);
        if (amount <= 0) {
            this.kill();
            return;
        }
        if (this.fails > maxPressure) {
            pollutant.explodeBlock(world, this.getTile().func_174877_v(), amount);
            this.kill();
            return;
        }
        world.field_72984_F.func_76320_a("TileEmission.emit");
        int count = this.emit(pollutant, amount);
        world.field_72984_F.func_76319_b();
        if (count > 0) {
            this.add(pollutant, -count);
            this.fails = 0;
        } else {
            ++this.fails;
        }
    }

    @Override
    public GameTime getUpdateInterval() {
        return this.updateInterval;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    public void kill() {
        this.exists = false;
    }
}

