/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.config;

import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.ItemState;
import com.endertech.minecraft.forge.units.StateHashMap;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.config.AbstractParsableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class FilterMaterials
extends AbstractParsableList {
    protected final Map<ItemState, MaterialData> materials = new StateHashMap();

    public FilterMaterials(UnitConfig config, String category) {
        super((ForgeConfig)config, category, "filterMaterials", new String[0]);
    }

    public Set<ItemState> getMaterials() {
        return Collections.unmodifiableSet(this.materials.keySet());
    }

    @Nullable
    protected MaterialData get(ItemStack stack) {
        return this.materials.get(ItemState.from((ItemStack)stack));
    }

    public boolean contains(ItemStack stack) {
        return this.get(stack) != null;
    }

    public boolean contains(ItemState state) {
        return this.materials.get(state) != null;
    }

    public ItemStack getByproductFor(ItemStack stack, int amount) {
        MaterialData material = this.get(stack);
        return material != null ? material.byproduct.toItemStack(amount) : ItemStack.field_190927_a;
    }

    public int getCapacityFor(ItemStack stack) {
        MaterialData material = this.get(stack);
        return material != null ? material.capacity : 0;
    }

    @Override
    protected String getComment() {
        return "List of materials which can be used to filter this pollutant.\nFormat: materialID, capacity, byproductID\n<materialID> - the id of the material that will be used to filter this pollutant,\n<capacity> - defines how many pollutant blocks this material can filter,\n<byproduct> - defines the byproduct of the used filter material.\nExample: minecraft:wool:*, 8, dustSulfur";
    }

    @Override
    protected void parseConfigValues() {
        this.materials.clear();
        for (String string : this.configValues) {
            boolean error;
            List<String> split = this.splitArgs(string);
            if (split.size() == 2) {
                split.add("minecraft:air");
            }
            boolean bl = error = split.size() < 3;
            if (!error) {
                UnitId materialId = UnitId.from((String)split.get(0));
                UnitId byproductId = UnitId.from((String)split.get(2));
                error = materialId.isEmpty();
                if (!error) {
                    Integer capacity = null;
                    ItemState byproduct = null;
                    try {
                        capacity = Integer.parseInt(split.get(1));
                        if (capacity <= 0) {
                            error = true;
                        }
                        byproduct = byproductId.getItemState();
                    }
                    catch (Exception e) {
                        error = true;
                    }
                    if (!error) {
                        for (ItemState state : materialId.getAllItemStates()) {
                            this.materials.put(state, new MaterialData(capacity, byproduct));
                        }
                    }
                }
            }
            if (!error) continue;
            this.logParsingError(string);
        }
    }

    protected class MaterialData {
        public final int capacity;
        public final ItemState byproduct;

        public MaterialData(int capacity, ItemState byproduct) {
            this.capacity = capacity;
            this.byproduct = byproduct;
        }
    }
}

