/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.blocks;

import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.mods.adpother.blocks.GasEmission;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.compat.DynamicTrees;
import java.util.Optional;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.MobEffects;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Carbon
extends GasEmission {
    public Carbon(ForgeMod mod, UnitConfig config, String name) {
        super(mod, config, (GasEmission.Properties)((Pollutant.Properties)((GasEmission.Properties)((GasEmission.Properties)((GasEmission.Properties)((GasEmission.Properties)GasEmission.Properties.of(name, MapColor.field_151670_w).criticalAmount(512)).concentrationAltitude(127)).motionVelocity(0.2f)).absorbtionChance(20)).lowerExplosiveLimit(10)).textColor(TextFormatting.GRAY));
        this.filterMaterials.addDefaultValues("treeLeaves, 8, dustCoal");
        this.negativeEffects.addGlobal(MobEffects.field_76419_f, Percentage.value((float)30.0f)).addGlobal(MobEffects.field_76438_s, Percentage.value((float)40.0f)).addGlobal(MobEffects.field_76437_t, Percentage.value((float)50.0f)).addGlobal(MobEffects.field_76421_d, Percentage.value((float)60.0f)).addGlobal(MobEffects.field_76436_u, Percentage.value((float)70.0f)).addGlobal(MobEffects.field_76431_k, Percentage.value((float)80.0f)).addGlobal(MobEffects.field_82731_v, Percentage.value((float)90.0f)).addHostile(MobEffects.field_76420_g, Percentage.value((float)40.0f)).addHostile(MobEffects.field_76428_l, Percentage.value((float)80.0f));
    }

    public boolean canAffectBlock(World world, BlockPos pos, Optional<EnumFacing> side, boolean directContact) {
        IBlockState state = world.func_180495_p(pos);
        Pollutant.BlockType type = this.getBlockType((IBlockAccess)world, pos, state);
        switch (type) {
            case IMMUNE: {
                return false;
            }
            case FILTER: {
                return true;
            }
            case GRASS_BLOCK: {
                return (directContact || this.isUnderRainOrStorm(world, pos)) && this.canAffectGrassIn(world.func_180494_b(pos));
            }
            case TALLGRASS: {
                return this.canAffectGrassIn(world.func_180494_b(pos));
            }
            case LEAVES: {
                return this.canAffectLeavesIn(world.func_180494_b(pos));
            }
            case PLANT: {
                return this.canAffectPlantsIn(world.func_180494_b(pos));
            }
        }
        return false;
    }

    @Override
    public IBlockState affectBlockAt(World world, BlockPos pos, Optional<EnumFacing> side, boolean directContact, IBlockState sourceState) {
        IBlockState state = world.func_180495_p(pos);
        if (this.isSamePollutant(sourceState) && this.canAffectBlock(world, pos, side, directContact)) {
            Pollutant.BlockType type = this.getBlockType((IBlockAccess)world, pos, state);
            switch (type) {
                case FILTER: {
                    if (!this.isFilteredAt(world, pos, side)) break;
                    return this.getSpreadedState(sourceState);
                }
                case LEAVES: {
                    if (!directContact) {
                        DynamicTrees.getTree().ifPresent(tree -> tree.pulseGrow(world, pos, state));
                    }
                    if (!this.isAbsorbedIn(world.func_180494_b(pos))) break;
                    if (directContact) {
                        world.func_175698_g(pos);
                    }
                    return this.getSpreadedState(sourceState);
                }
                case GRASS_BLOCK: 
                case TALLGRASS: 
                case PLANT: {
                    if (!this.doBonemealEffect(world, pos, state)) break;
                    return this.getSpreadedState(sourceState);
                }
            }
        }
        return sourceState;
    }
}

