/*
 * Decompiled with CFR 0.152.
 */
package noisethreader.mixin.bettercaves;

import com.yungnickyoung.minecraft.bettercaves.noise.FastNoise;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseColumn;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseCube;
import com.yungnickyoung.minecraft.bettercaves.world.CaveCarverController;
import com.yungnickyoung.minecraft.bettercaves.world.carver.CarverNoiseRange;
import com.yungnickyoung.minecraft.bettercaves.world.carver.cave.CaveCarver;
import com.yungnickyoung.minecraft.bettercaves.world.carver.vanilla.VanillaCaveCarver;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraftforge.common.BiomeDictionary;
import noisethreader.NoiseThreader;
import noisethreader.util.ColumnCarverHolder;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={CaveCarverController.class})
public abstract class CaveCarverControllerMixin {
    @Shadow(remap=false)
    private List<CarverNoiseRange> noiseRanges;
    @Shadow(remap=false)
    private boolean isSurfaceCavesEnabled;
    @Shadow(remap=false)
    private boolean isOverrideSurfaceDetectionEnabled;
    @Shadow(remap=false)
    private boolean isFloodedUndergroundEnabled;
    @Shadow(remap=false)
    private boolean isDebugViewEnabled;
    @Shadow(remap=false)
    private FastNoise caveRegionController;
    @Shadow(remap=false)
    private VanillaCaveCarver surfaceCaveCarver;
    @Shadow(remap=false)
    private World world;
    @Unique
    private boolean noisethreader$shouldCarveVanillaCaves = false;
    @Unique
    private boolean[][] noisethreader$vanillaCarvingMask = null;
    @Unique
    private ColumnCarverHolder[][][][] noisethreader$columnCarverHolders = null;

    @Overwrite(remap=false)
    public void carveChunk(ChunkPrimer primer, int chunkX, int chunkZ, int[][] surfaceAltitudes, IBlockState[][] liquidBlocks) {
        if (this.noiseRanges.isEmpty() && !this.isSurfaceCavesEnabled) {
            return;
        }
        this.noisethreader$shouldCarveVanillaCaves = false;
        this.noisethreader$vanillaCarvingMask = new boolean[16][16];
        this.noisethreader$columnCarverHolders = new ColumnCarverHolder[4][4][4][4];
        try {
            IntStream.range(0, 16).parallel().forEach(subIndex -> this.noisethreader$genChunkCarverSection(chunkX, chunkZ, surfaceAltitudes, liquidBlocks, subIndex / 4, subIndex % 4));
        }
        catch (Exception ex) {
            NoiseThreader.LOGGER.log(Level.ERROR, "NoiseThreader BetterCaves Multithreaded Noise encountered an error: " + ex.getMessage(), (Throwable)ex);
            this.noisethreader$carveChunkOriginal(primer, chunkX, chunkZ, surfaceAltitudes, liquidBlocks);
            this.noisethreader$vanillaCarvingMask = null;
            this.noisethreader$columnCarverHolders = null;
            return;
        }
        for (int subX = 0; subX < 4; ++subX) {
            for (int subZ = 0; subZ < 4; ++subZ) {
                for (int offsetX = 0; offsetX < 4; ++offsetX) {
                    for (int offsetZ = 0; offsetZ < 4; ++offsetZ) {
                        ColumnCarverHolder columnCarverHolder = this.noisethreader$columnCarverHolders[subX][subZ][offsetX][offsetZ];
                        if (columnCarverHolder == null) continue;
                        ((CaveCarver)this.noiseRanges.get(columnCarverHolder.carverIndex).getCarver()).carveColumn(primer, columnCarverHolder.colPos, columnCarverHolder.topY, columnCarverHolder.noiseColumn, columnCarverHolder.liquidBlock, columnCarverHolder.flooded);
                    }
                }
            }
        }
        if (this.noisethreader$shouldCarveVanillaCaves) {
            VanillaCaveCarver carver = null;
            for (CarverNoiseRange range : this.noiseRanges) {
                if (!(range.getCarver() instanceof VanillaCaveCarver)) continue;
                carver = (VanillaCaveCarver)range.getCarver();
                break;
            }
            if (carver != null) {
                carver.generate(this.world, chunkX, chunkZ, primer, true, liquidBlocks, this.noisethreader$vanillaCarvingMask);
            }
        }
        if (this.isSurfaceCavesEnabled) {
            this.surfaceCaveCarver.generate(this.world, chunkX, chunkZ, primer, false, liquidBlocks);
        }
        this.noisethreader$vanillaCarvingMask = null;
        this.noisethreader$columnCarverHolders = null;
    }

    @Unique
    private void noisethreader$genChunkCarverSection(int chunkX, int chunkZ, int[][] surfaceAltitudes, IBlockState[][] liquidBlocks, int subX, int subZ) {
        int startX = subX * 4;
        int startZ = subZ * 4;
        int endX = startX + 4 - 1;
        int endZ = startZ + 4 - 1;
        BlockPos startPos = new BlockPos(chunkX * 16 + startX, 1, chunkZ * 16 + startZ);
        BlockPos endPos = new BlockPos(chunkX * 16 + endX, 1, chunkZ * 16 + endZ);
        int maxHeight = 0;
        if (!this.isOverrideSurfaceDetectionEnabled) {
            for (int x = startX; x < endX; ++x) {
                for (int z = startZ; z < endZ; ++z) {
                    maxHeight = Math.max(maxHeight, surfaceAltitudes[x][z]);
                }
            }
            for (CarverNoiseRange range : this.noiseRanges) {
                maxHeight = Math.max(maxHeight, range.getCarver().getTopY());
            }
        }
        NoiseCube[] noiseCubes = new NoiseCube[this.noiseRanges.size()];
        for (int offsetX = 0; offsetX < 4; ++offsetX) {
            block4: for (int offsetZ = 0; offsetZ < 4; ++offsetZ) {
                boolean flooded;
                int localX = startX + offsetX;
                int localZ = startZ + offsetZ;
                BlockPos colPos = new BlockPos(chunkX * 16 + localX, 1, chunkZ * 16 + localZ);
                boolean bl = flooded = this.isFloodedUndergroundEnabled && !this.isDebugViewEnabled && BiomeDictionary.hasType((Biome)this.world.func_180494_b(colPos), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN);
                if (flooded && (!BiomeDictionary.hasType((Biome)this.world.func_180494_b(colPos.func_177974_f()), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || !BiomeDictionary.hasType((Biome)this.world.func_180494_b(colPos.func_177978_c()), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || !BiomeDictionary.hasType((Biome)this.world.func_180494_b(colPos.func_177976_e()), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || !BiomeDictionary.hasType((Biome)this.world.func_180494_b(colPos.func_177968_d()), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN))) continue;
                int surfaceAltitude = surfaceAltitudes[localX][localZ];
                IBlockState liquidBlock = liquidBlocks[localX][localZ];
                float caveRegionNoise = this.caveRegionController.GetNoise((float)colPos.func_177958_n(), (float)colPos.func_177952_p());
                for (int rangeIndex = 0; rangeIndex < this.noiseRanges.size(); ++rangeIndex) {
                    CarverNoiseRange range = this.noiseRanges.get(rangeIndex);
                    if (!range.contains(caveRegionNoise)) continue;
                    if (range.getCarver() instanceof CaveCarver) {
                        CaveCarver carver = (CaveCarver)range.getCarver();
                        int bottomY = carver.getBottomY();
                        int topY = Math.min(surfaceAltitude, carver.getTopY());
                        if (this.isOverrideSurfaceDetectionEnabled) {
                            topY = carver.getTopY();
                            maxHeight = carver.getTopY();
                        }
                        if (this.isDebugViewEnabled) {
                            topY = 128;
                            maxHeight = 128;
                        }
                        if (noiseCubes[rangeIndex] == null) {
                            noiseCubes[rangeIndex] = carver.getNoiseGen().interpolateNoiseCube(startPos, endPos, bottomY, maxHeight);
                        }
                        NoiseColumn noiseColumn = (NoiseColumn)noiseCubes[rangeIndex].get(offsetX).get(offsetZ);
                        this.noisethreader$columnCarverHolders[subX][subZ][offsetX][offsetZ] = new ColumnCarverHolder(rangeIndex, colPos, topY, noiseColumn, liquidBlock, flooded);
                        continue block4;
                    }
                    if (!(range.getCarver() instanceof VanillaCaveCarver)) continue;
                    this.noisethreader$shouldCarveVanillaCaves = true;
                    this.noisethreader$vanillaCarvingMask[localX][localZ] = true;
                }
            }
        }
    }

    @Unique
    private void noisethreader$carveChunkOriginal(ChunkPrimer primer, int chunkX, int chunkZ, int[][] surfaceAltitudes, IBlockState[][] liquidBlocks) {
        if (this.noiseRanges.isEmpty() && !this.isSurfaceCavesEnabled) {
            return;
        }
        boolean shouldCarveVanillaCaves = false;
        boolean[][] vanillaCarvingMask = new boolean[16][16];
        for (int subX = 0; subX < 4; ++subX) {
            for (int subZ = 0; subZ < 4; ++subZ) {
                int startX = subX * 4;
                int startZ = subZ * 4;
                int endX = startX + 4 - 1;
                int endZ = startZ + 4 - 1;
                BlockPos startPos = new BlockPos(chunkX * 16 + startX, 1, chunkZ * 16 + startZ);
                BlockPos endPos = new BlockPos(chunkX * 16 + endX, 1, chunkZ * 16 + endZ);
                this.noiseRanges.forEach(rangex -> rangex.setNoiseCube(null));
                int maxHeight = 0;
                if (!this.isOverrideSurfaceDetectionEnabled) {
                    for (int x = startX; x < endX; ++x) {
                        for (int z = startZ; z < endZ; ++z) {
                            maxHeight = Math.max(maxHeight, surfaceAltitudes[x][z]);
                        }
                    }
                    for (CarverNoiseRange range : this.noiseRanges) {
                        maxHeight = Math.max(maxHeight, range.getCarver().getTopY());
                    }
                }
                for (int offsetX = 0; offsetX < 4; ++offsetX) {
                    block6: for (int offsetZ = 0; offsetZ < 4; ++offsetZ) {
                        boolean flooded;
                        int localX = startX + offsetX;
                        int localZ = startZ + offsetZ;
                        BlockPos colPos = new BlockPos(chunkX * 16 + localX, 1, chunkZ * 16 + localZ);
                        boolean bl = flooded = this.isFloodedUndergroundEnabled && !this.isDebugViewEnabled && BiomeDictionary.hasType((Biome)this.world.func_180494_b(colPos), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN);
                        if (flooded && (!BiomeDictionary.hasType((Biome)this.world.func_180494_b(colPos.func_177974_f()), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || !BiomeDictionary.hasType((Biome)this.world.func_180494_b(colPos.func_177978_c()), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || !BiomeDictionary.hasType((Biome)this.world.func_180494_b(colPos.func_177976_e()), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || !BiomeDictionary.hasType((Biome)this.world.func_180494_b(colPos.func_177968_d()), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN))) continue;
                        int surfaceAltitude = surfaceAltitudes[localX][localZ];
                        IBlockState liquidBlock = liquidBlocks[localX][localZ];
                        float caveRegionNoise = this.caveRegionController.GetNoise((float)colPos.func_177958_n(), (float)colPos.func_177952_p());
                        for (CarverNoiseRange range : this.noiseRanges) {
                            if (!range.contains(caveRegionNoise)) continue;
                            if (range.getCarver() instanceof CaveCarver) {
                                CaveCarver carver = (CaveCarver)range.getCarver();
                                int bottomY = carver.getBottomY();
                                int topY = Math.min(surfaceAltitude, carver.getTopY());
                                if (this.isOverrideSurfaceDetectionEnabled) {
                                    topY = carver.getTopY();
                                    maxHeight = carver.getTopY();
                                }
                                if (this.isDebugViewEnabled) {
                                    topY = 128;
                                    maxHeight = 128;
                                }
                                if (range.getNoiseCube() == null) {
                                    range.setNoiseCube(carver.getNoiseGen().interpolateNoiseCube(startPos, endPos, bottomY, maxHeight));
                                }
                                NoiseColumn noiseColumn = (NoiseColumn)range.getNoiseCube().get(offsetX).get(offsetZ);
                                carver.carveColumn(primer, colPos, topY, noiseColumn, liquidBlock, flooded);
                                continue block6;
                            }
                            if (!(range.getCarver() instanceof VanillaCaveCarver)) continue;
                            vanillaCarvingMask[localX][localZ] = true;
                            shouldCarveVanillaCaves = true;
                        }
                    }
                }
            }
        }
        if (shouldCarveVanillaCaves) {
            VanillaCaveCarver carver = null;
            for (CarverNoiseRange range : this.noiseRanges) {
                if (!(range.getCarver() instanceof VanillaCaveCarver)) continue;
                carver = (VanillaCaveCarver)range.getCarver();
                break;
            }
            if (carver != null) {
                carver.generate(this.world, chunkX, chunkZ, primer, true, liquidBlocks, vanillaCarvingMask);
            }
        }
        if (this.isSurfaceCavesEnabled) {
            this.surfaceCaveCarver.generate(this.world, chunkX, chunkZ, primer, false, liquidBlocks);
        }
    }
}

