/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.qualitytools;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.tmtravlr.qualitytools.QualityToolsHelper;
import com.tmtravlr.qualitytools.baubles.BaublesHandler;
import com.tmtravlr.qualitytools.config.ConfigLoader;
import com.tmtravlr.qualitytools.items.ItemEmeraldBauble;
import com.tmtravlr.qualitytools.reforging.BlockReforgingStation;
import com.tmtravlr.qualitytools.reforging.TileEntityReforgingStation;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.HorseArmorType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="qualitytools")
public class CommonEventHandler {
    private static boolean notified;

    @SubscribeEvent
    public static void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)BlockReforgingStation.INSTANCE);
        TileEntity.func_190560_a((String)"qualitytools.reforging_station", TileEntityReforgingStation.class);
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)ItemEmeraldBauble.EMERALD_RING);
        registry.register((IForgeRegistryEntry)ItemEmeraldBauble.EMERALD_AMULET);
        registry.register((IForgeRegistryEntry)BlockReforgingStation.ITEM_INSTANCE);
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            if (event.getEntityLiving().field_70173_aa % 13 == 0 && event.getEntityLiving() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                if (!notified) {
                    if (!ConfigLoader.problems.isEmpty()) {
                        ConfigLoader.notifyProblems(player);
                    }
                    notified = true;
                }
                ArrayList itemsToCheck = new ArrayList();
                if (player.field_71071_by != null) {
                    itemsToCheck.addAll(player.field_71071_by.field_70462_a);
                    itemsToCheck.addAll(player.field_71071_by.field_70460_b);
                    itemsToCheck.addAll(player.field_71071_by.field_184439_c);
                }
                BaublesHandler.INSTANCE.addEquippedBaubles(player, itemsToCheck);
                itemsToCheck.forEach(stack -> {
                    if (!QualityToolsHelper.hasQualityTag(stack)) {
                        QualityToolsHelper.generateQualityTag(stack, false);
                    }
                });
            }
            if (event.getEntityLiving().field_70173_aa % 7 == 0) {
                EntityHorse horse;
                HashMultimap modifiersToRemove = HashMultimap.create();
                for (IAttributeInstance attribute : event.getEntityLiving().func_110140_aT().func_111146_a()) {
                    for (AttributeModifier modifier : attribute.func_111122_c()) {
                        if (!modifier.func_111166_b().equals("qualitytools")) continue;
                        modifiersToRemove.put((Object)attribute.func_111123_a().func_111108_a(), (Object)modifier);
                    }
                }
                ItemStack item = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.MAINHAND);
                QualityToolsHelper.applyAttributesForSlot(event.getEntityLiving(), item, EntityEquipmentSlot.MAINHAND.func_188450_d(), (Multimap<String, AttributeModifier>)modifiersToRemove);
                item = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.OFFHAND);
                QualityToolsHelper.applyAttributesForSlot(event.getEntityLiving(), item, EntityEquipmentSlot.OFFHAND.func_188450_d(), (Multimap<String, AttributeModifier>)modifiersToRemove);
                item = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.HEAD);
                QualityToolsHelper.applyAttributesForSlot(event.getEntityLiving(), item, EntityEquipmentSlot.HEAD.func_188450_d(), (Multimap<String, AttributeModifier>)modifiersToRemove);
                item = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST);
                QualityToolsHelper.applyAttributesForSlot(event.getEntityLiving(), item, EntityEquipmentSlot.CHEST.func_188450_d(), (Multimap<String, AttributeModifier>)modifiersToRemove);
                item = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.LEGS);
                QualityToolsHelper.applyAttributesForSlot(event.getEntityLiving(), item, EntityEquipmentSlot.LEGS.func_188450_d(), (Multimap<String, AttributeModifier>)modifiersToRemove);
                item = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.FEET);
                QualityToolsHelper.applyAttributesForSlot(event.getEntityLiving(), item, EntityEquipmentSlot.FEET.func_188450_d(), (Multimap<String, AttributeModifier>)modifiersToRemove);
                if (event.getEntityLiving() instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                    BaublesHandler.INSTANCE.applyAttributesFromBaubles(player, (Multimap<String, AttributeModifier>)modifiersToRemove);
                    for (ItemStack inventoryItem : player.field_71071_by.field_70462_a) {
                        QualityToolsHelper.applyAttributesForSlot(event.getEntityLiving(), inventoryItem, "inventory", (Multimap<String, AttributeModifier>)modifiersToRemove);
                    }
                }
                if (event.getEntityLiving() instanceof EntityHorse && (horse = (EntityHorse)event.getEntityLiving()).func_184783_dl() != HorseArmorType.NONE) {
                    try {
                        NBTTagCompound horseTag = horse.func_189511_e(new NBTTagCompound());
                        if (horseTag.func_150297_b("ArmorItem", 10)) {
                            NBTTagCompound armorTag = horseTag.func_74775_l("ArmorItem");
                            ItemStack armorItem = new ItemStack(armorTag);
                            QualityToolsHelper.applyAttributesForSlot(event.getEntityLiving(), armorItem, "horse", (Multimap<String, AttributeModifier>)modifiersToRemove);
                        }
                    }
                    catch (Exception e) {
                        FMLLog.warning((String)"[Quality Tools] Caught exception while trying to find horse armor", (Object[])new Object[0]);
                        e.printStackTrace();
                    }
                }
                event.getEntityLiving().func_110140_aT().func_111148_a((Multimap)modifiersToRemove);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)event.getEntity();
            for (IAttributeInstance attribute : entity.func_110140_aT().func_111146_a()) {
                for (AttributeModifier modifier : attribute.func_111122_c()) {
                    if (!modifier.func_111166_b().equals("qualitytools")) continue;
                    attribute.func_111124_b(modifier);
                    attribute.func_111121_a(modifier);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            ConfigLoader.sendReforgingMaterialsToClient((EntityPlayerMP)event.player);
        }
    }
}

