/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thedarkcolour.futuremc.recipe.campfire.CampfireRecipes;

@ZenRegister
@ZenClass(value="mods.futuremc.Campfire")
public final class Campfire {
    @ZenMethod
    public static void addRecipe(IIngredient input, IItemStack output, int duration) {
        CraftTweakerAPI.apply((IAction)new AddRecipe(input, output, duration));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack stack) {
        if (CampfireRecipes.INSTANCE.getRecipe(CraftTweakerMC.getItemStack((IItemStack)stack)) != null) {
            CraftTweakerAPI.apply((IAction)new RemoveRecipe(stack));
        }
    }

    @ZenMethod
    public static void clearRecipes() {
        CampfireRecipes.INSTANCE.clear();
    }

    private static final class RemoveRecipe
    implements IAction {
        private final IItemStack input;

        private RemoveRecipe(IItemStack input) {
            this.input = input;
        }

        public void apply() {
            CampfireRecipes.INSTANCE.removeRecipeForInput(CraftTweakerMC.getItemStack((IItemStack)this.input));
        }

        public String describe() {
            return "Added recipe for" + this.input.getDefinition().getId();
        }
    }

    private static final class AddRecipe
    implements IAction {
        private final IIngredient input;
        private final IItemStack output;
        private final int duration;

        private AddRecipe(IIngredient input, IItemStack output, int duration) {
            this.input = input;
            this.output = output;
            this.duration = duration;
        }

        public void apply() {
            ItemStack output = CraftTweakerMC.getItemStack((IItemStack)this.output);
            CampfireRecipes.INSTANCE.addRecipe(CraftTweakerMC.getIngredient((IIngredient)this.input), output, this.duration);
        }

        public String describe() {
            return "Added recipe for " + this.input.toCommandString();
        }
    }
}

