/*
 * Decompiled with CFR 0.152.
 */
package quarris.rotm.items;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import quarris.rotm.utils.Utils;

public class ItemDebug
extends Item {
    public DebugType type;

    public ItemDebug(DebugType type) {
        this.type = type;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K || !player.func_70093_af()) {
            return super.func_77659_a(world, player, hand);
        }
        if (player.func_70093_af()) {
            String message = "Self: ";
            switch (this.type) {
                case DAMAGE: {
                    message = message + (player.getEntityData().func_74764_b("LastDamageSource") ? player.getEntityData().func_74779_i("LastDamageSource") : "No damage taken!");
                    break;
                }
                case ENTITY: {
                    message = message + "minecraft:player";
                    break;
                }
                case POTION: {
                    List activePotionEffectStrings = player.func_70651_bq().stream().map(effect -> effect.func_188419_a().getRegistryName().toString()).collect(Collectors.toList());
                    message = message + activePotionEffectStrings.toString();
                    break;
                }
                default: {
                    message = message + "Invalid Debug Type";
                }
            }
            player.func_145747_a((ITextComponent)new TextComponentString(message));
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (player.field_70170_p.field_72995_K || player.func_70093_af()) {
            return false;
        }
        String message = "Target: ";
        switch (this.type) {
            case DAMAGE: {
                message = message + (target.getEntityData().func_74764_b("LastDamageSource") ? target.getEntityData().func_74779_i("LastDamageSource") : "No damage taken!");
                break;
            }
            case ENTITY: {
                message = message + Utils.getEntityName((Entity)target).toString();
                break;
            }
            case POTION: {
                List activePotionEffectStrings = target.func_70651_bq().stream().map(effect -> effect.func_188419_a().getRegistryName().toString()).collect(Collectors.toList());
                message = message + activePotionEffectStrings.toString();
                break;
            }
            default: {
                message = message + "Invalid Bug Type";
            }
        }
        player.func_145747_a((ITextComponent)new TextComponentString(message));
        return super.func_111207_a(stack, player, target, hand);
    }

    public static enum DebugType {
        DAMAGE,
        ENTITY,
        POTION;

    }
}

