/*
 * Decompiled with CFR 0.152.
 */
package quarris.rotm.event;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import quarris.rotm.capability.SpawnSummonsCap;
import quarris.rotm.config.EntityConfig;
import quarris.rotm.config.ModConfigs;
import quarris.rotm.config.types.HealthRegainType;
import quarris.rotm.config.types.MobDefenseType;
import quarris.rotm.config.types.MobOffenseType;
import quarris.rotm.utils.Utils;

@Mod.EventBusSubscriber(modid="rotm")
public class EntityEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void cancelPotionApply(PotionEvent.PotionApplicableEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        Set potionsToCancel = ModConfigs.entityConfigs.potionsToCancel.get((Object)Utils.getEntityName((Entity)entity));
        if (potionsToCancel.contains(event.getPotionEffect().func_188419_a().getRegistryName())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void cancelDamageSource(LivingAttackEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        EntityConfig config = ModConfigs.entityConfigs;
        ResourceLocation entityName = Utils.getEntityName((Entity)entity);
        HashSet sourcesToCancel = new HashSet();
        sourcesToCancel.addAll(config.damagesToCancel.get((Object)Pair.of((Object)entityName, null)));
        if (source.func_76346_g() != null) {
            sourcesToCancel.addAll(config.damagesToCancel.get((Object)Pair.of((Object)entityName, (Object)Utils.getEntityName(source.func_76346_g()))));
        }
        if (source.func_76364_f() != null) {
            sourcesToCancel.addAll(config.damagesToCancel.get((Object)Pair.of((Object)entityName, (Object)Utils.getEntityName(source.func_76364_f()))));
        }
        if (sourcesToCancel.contains(source.func_76355_l())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void summonSpawns(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K || event.getEntityLiving().field_70128_L || !event.getEntityLiving().hasCapability(SpawnSummonsCap.instance, null)) {
            return;
        }
        SpawnSummonsCap cap = (SpawnSummonsCap)event.getEntityLiving().getCapability(SpawnSummonsCap.instance, null);
        cap.update();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void summonSpawnsDespawnOnDeath(LivingDeathEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K || !event.getEntityLiving().hasCapability(SpawnSummonsCap.instance, null)) {
            return;
        }
        SpawnSummonsCap cap = (SpawnSummonsCap)event.getEntityLiving().getCapability(SpawnSummonsCap.instance, null);
        cap.despawnSummons();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void disableXPOnDeath(LivingExperienceDropEvent event) {
        if (event.getEntityLiving().getEntityData().func_74767_n("DisableXP")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void disableLootOnDeath(LivingDropsEvent event) {
        if (event.getEntityLiving().getEntityData().func_74767_n("DisableLoot")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void deathSpawn(LivingDeathEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        ModConfigs.entityConfigs.deathSpawns.get((Object)Utils.getEntityName((Entity)entity)).stream().forEach(spawn -> {
            Random random = new Random();
            int amount = spawn.minSpawn + random.nextInt(spawn.maxSpawn - spawn.minSpawn + 1);
            if (random.nextFloat() > spawn.chance) {
                amount = 0;
            }
            boolean spawned = false;
            block0: for (int i = 0; i < amount; ++i) {
                Entity toSpawn = EntityList.func_188429_b((ResourceLocation)spawn.summon, (World)entity.field_70170_p);
                if (toSpawn == null) continue;
                if (toSpawn instanceof EntityLiving) {
                    ((EntityLiving)toSpawn).func_180482_a(entity.field_70170_p.func_175649_E(toSpawn.func_180425_c()), null);
                }
                toSpawn.deserializeNBT(spawn.nbt);
                if (spawn.disableLoot) {
                    toSpawn.getEntityData().func_74757_a("DisableXP", true);
                }
                if (spawn.disableXP) {
                    toSpawn.getEntityData().func_74757_a("DisableLoot", true);
                }
                if (toSpawn instanceof EntityLiving && entity instanceof EntityLiving && spawn.autoAggro) {
                    ((EntityLiving)toSpawn).func_70624_b(((EntityLiving)entity).func_70638_az());
                }
                BlockPos entityPos = entity.func_180425_c();
                int tries = 50;
                for (int j = 0; j < tries; ++j) {
                    toSpawn.func_70012_b((double)((float)entityPos.func_177958_n() + random.nextFloat() * 8.0f - 4.0f), (double)(entityPos.func_177956_o() + random.nextInt(5)) - 1.5, (double)((float)entityPos.func_177952_p() + random.nextFloat() * 8.0f - 4.0f), random.nextFloat() * 360.0f, 0.0f);
                    if (!EntityEventHandler.isPositionValidForSpawningSummons(toSpawn, entityPos) || !entity.field_70170_p.func_72838_d(toSpawn)) continue;
                    spawned = true;
                    continue block0;
                }
            }
            if (spawned && spawn.sound != null) {
                entity.field_70170_p.func_184133_a(null, entity.func_180425_c(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(spawn.sound), SoundCategory.HOSTILE, 1.0f, 1.0f);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void applyMobOffenseEffect(LivingHurtEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getAmount() > 0.0f) {
            EntityLivingBase entity = event.getEntityLiving();
            DamageSource source = event.getSource();
            if (source.func_76346_g() instanceof EntityLivingBase) {
                EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
                Collection offenseTypes = ModConfigs.entityConfigs.mobOffense.get((Object)Utils.getEntityName((Entity)attacker));
                for (MobOffenseType type : offenseTypes) {
                    if (!type.canApplyToEntity(attacker) || !type.damageType.isEmpty() && !type.damageType.equalsIgnoreCase(source.func_76355_l())) continue;
                    PotionEffect effect = new PotionEffect((Potion)ForgeRegistries.POTIONS.getValue(type.potion), type.duration, type.level);
                    entity.func_70690_d(effect);
                    if (type.sound == null) continue;
                    entity.field_70170_p.func_184133_a(null, attacker.func_180425_c(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(type.sound), SoundCategory.HOSTILE, 1.0f, 1.0f);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void applyMobDefenseEffect(LivingHurtEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            EntityLivingBase entity = event.getEntityLiving();
            DamageSource source = event.getSource();
            if (source.func_76346_g() instanceof EntityLivingBase) {
                EntityLivingBase attacker = (EntityLivingBase)source.func_76346_g();
                Collection defenseTypes = ModConfigs.entityConfigs.mobDefenses.get((Object)Utils.getEntityName((Entity)entity));
                for (MobDefenseType type : defenseTypes) {
                    if (!type.canApplyToEntity(entity) || !type.damageType.isEmpty() && !type.damageType.equalsIgnoreCase(source.func_76355_l())) continue;
                    PotionEffect effect = new PotionEffect((Potion)ForgeRegistries.POTIONS.getValue(type.potion), type.duration, type.level);
                    attacker.func_70690_d(effect);
                    if (type.sound == null) continue;
                    entity.field_70170_p.func_184133_a(null, entity.func_180425_c(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(type.sound), SoundCategory.HOSTILE, 1.0f, 1.0f);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void applyHealthRegain(LivingDeathEvent event) {
        World world = event.getEntityLiving().field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        EntityLivingBase dead = event.getEntityLiving();
        List loaded = world.field_72996_f.stream().filter(entity -> entity instanceof EntityLivingBase).map(entity -> (EntityLivingBase)entity).collect(Collectors.toList());
        for (EntityLivingBase entity2 : loaded) {
            List types = ModConfigs.entityConfigs.healthRegains.get((Object)EntityList.func_191301_a((Entity)entity2)).stream().filter(type -> type.target == null || type.target.equals((Object)Utils.getEntityName((Entity)dead))).collect(Collectors.toList());
            for (HealthRegainType type2 : types) {
                if (!(type2.radius <= 0.0f) && !(dead.func_70068_e((Entity)entity2) <= (double)(type2.radius * type2.radius)) || type2.lastManStanding && loaded.stream().filter(e -> e != null && Utils.getEntityName((Entity)e).equals((Object)type.target)).count() != 1L) continue;
                entity2.func_70691_i(entity2.func_110138_aP() * type2.healthPercentage);
            }
        }
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityLivingBase && ModConfigs.entityConfigs.summonSpawns.keySet().contains(Utils.getEntityName((Entity)event.getObject()))) {
            event.addCapability(new ResourceLocation("rotm", "summonspawn"), (ICapabilityProvider)new SpawnSummonsCap((EntityLivingBase)event.getObject()));
        }
    }

    public static boolean isPositionValidForSpawningSummons(Entity entity, BlockPos pos) {
        if (!entity.field_70170_p.func_175723_af().func_177746_a(pos)) {
            return false;
        }
        return !Utils.isEntityInCollision(entity.field_70170_p, entity);
    }
}

