/*
 * Decompiled with CFR 0.152.
 */
package quarris.rotm.config.types;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class SummonSpawnType {
    public final ResourceLocation summon;
    public final int id;
    public final float health;
    public final int minSpawn;
    public final int maxSpawn;
    public final int minCooldownTicks;
    public final int maxCooldownTicks;
    public final boolean bypassMaxSpawns;
    public final boolean despawnOnDeath;
    public final int cap;
    public final boolean disableXP;
    public final boolean disableLoot;
    public final boolean autoAggro;
    public final boolean requireTarget;
    public final ResourceLocation sound;
    public final NBTTagCompound nbt;

    SummonSpawnType(ResourceLocation summon, int id, float health, int minSpawn, int maxSpawn, int minCooldown, int maxCooldown, boolean bypassMaxSpawns, boolean despawnOnDeath, int cap, boolean disableXP, boolean disableLoot, boolean autoAggro, boolean requireTarget, ResourceLocation sound, NBTTagCompound nbt) {
        this.summon = summon;
        this.id = id;
        this.health = health;
        this.minSpawn = minSpawn;
        this.maxSpawn = maxSpawn;
        this.minCooldownTicks = minCooldown * 20;
        this.maxCooldownTicks = maxCooldown * 20;
        this.bypassMaxSpawns = bypassMaxSpawns;
        this.despawnOnDeath = despawnOnDeath;
        this.cap = cap;
        this.disableXP = disableXP;
        this.disableLoot = disableLoot;
        this.autoAggro = autoAggro;
        this.requireTarget = requireTarget;
        this.sound = sound;
        this.nbt = nbt;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SummonType{");
        sb.append("summon=").append(this.summon);
        sb.append(", id=").append(this.id);
        sb.append(", health=").append(this.health);
        sb.append(", minSpawn=").append(this.minSpawn);
        sb.append(", maxSpawn=").append(this.maxSpawn);
        sb.append(", minCooldownTicks=").append(this.minCooldownTicks);
        sb.append(", maxCooldownTicks=").append(this.maxCooldownTicks);
        sb.append(", bypassMaxSpawns=").append(this.bypassMaxSpawns);
        sb.append(", despawnOnDeath=").append(this.despawnOnDeath);
        sb.append(", cap=").append(this.cap);
        sb.append(", disableXP=").append(this.disableXP);
        sb.append(", disableLoot=").append(this.disableLoot);
        sb.append(", autoAggro=").append(this.autoAggro);
        sb.append(", requireTarget=").append(this.requireTarget);
        sb.append(", sound=").append(this.sound);
        sb.append(", nbt=").append(this.nbt);
        sb.append('}');
        return sb.toString();
    }

    public static class Builder {
        public ResourceLocation summon;
        public int id;
        public float health;
        public int minSpawn;
        public int maxSpawn;
        public int minCooldown;
        public int maxCooldown;
        public boolean bypassMaxSpawns;
        public boolean despawnOnDeath;
        public int cap;
        public boolean disableXP;
        public boolean disableLoot;
        public boolean autoAggro;
        public boolean requireTarget;
        public ResourceLocation sound;
        public NBTTagCompound nbt;

        Builder() {
        }

        public Builder summon(ResourceLocation summon) {
            this.summon = summon;
            return this;
        }

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder health(float health) {
            this.health = health / 100.0f;
            return this;
        }

        public Builder minSpawn(int minSpawn) {
            this.minSpawn = minSpawn;
            return this;
        }

        public Builder maxSpawn(int maxSpawn) {
            this.maxSpawn = maxSpawn;
            return this;
        }

        public Builder minCooldown(int minCooldown) {
            this.minCooldown = minCooldown;
            return this;
        }

        public Builder maxCooldown(int maxCooldown) {
            this.maxCooldown = maxCooldown;
            return this;
        }

        public Builder bypassMaxSpawns(boolean bypassMaxSpawns) {
            this.bypassMaxSpawns = bypassMaxSpawns;
            return this;
        }

        public Builder despawnOnDeath(boolean despawnOnDeath) {
            this.despawnOnDeath = despawnOnDeath;
            return this;
        }

        public Builder cap(int cap) {
            this.cap = cap;
            return this;
        }

        public Builder disableXP(boolean disableXP) {
            this.disableXP = disableXP;
            return this;
        }

        public Builder disableLoot(boolean disableLoot) {
            this.disableLoot = disableLoot;
            return this;
        }

        public Builder autoAggro(boolean autoAggro) {
            this.autoAggro = autoAggro;
            return this;
        }

        public Builder requireTarget(boolean requireTarget) {
            this.requireTarget = requireTarget;
            return this;
        }

        public Builder sound(ResourceLocation sound) {
            this.sound = sound;
            return this;
        }

        public Builder nbt(NBTTagCompound nbt) {
            this.nbt = nbt;
            return this;
        }

        public SummonSpawnType build() {
            return new SummonSpawnType(this.summon, this.id, this.health, this.minSpawn, this.maxSpawn, this.minCooldown, this.maxCooldown, this.bypassMaxSpawns, this.despawnOnDeath, this.cap, this.disableXP, this.disableLoot, this.autoAggro, this.requireTarget, this.sound, this.nbt);
        }
    }
}

