/*
 * Decompiled with CFR 0.152.
 */
package quarris.rotm.config.types;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;

public class MobOffenseType {
    public ResourceLocation potion;
    public int level;
    public int duration;
    public float health;
    public float chance;
    public ResourceLocation sound;
    public List<Integer> dimensions;
    public boolean blockDimensions;
    public String damageType;

    public MobOffenseType(ResourceLocation potion, int level, int duration, float health, float chance, ResourceLocation sound, List<Integer> dimensions, boolean blockDimensions, String damageType) {
        this.potion = potion;
        this.level = level;
        this.duration = duration;
        this.health = health;
        this.chance = chance;
        this.sound = sound;
        this.dimensions = dimensions;
        this.blockDimensions = blockDimensions;
        this.damageType = damageType;
    }

    public boolean canApplyToEntity(EntityLivingBase entity) {
        return (this.health == 1.0f || entity.func_110143_aJ() / entity.func_110138_aP() <= this.health) && (this.chance == 1.0f || entity.field_70170_p.field_73012_v.nextFloat() <= this.chance) && this.blockDimensions != this.dimensions.contains(entity.field_71093_bK);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MobAttackType{");
        sb.append("potion=").append(this.potion);
        sb.append(", level=").append(this.level);
        sb.append(", duration=").append(this.duration);
        sb.append(", health=").append(this.health);
        sb.append(", chance=").append(this.chance);
        sb.append(", sound=").append(this.sound);
        sb.append(", dimensions=").append(this.dimensions);
        sb.append(", blockDimensions=").append(this.blockDimensions);
        sb.append(", damageType=").append(this.damageType);
        sb.append('}');
        return sb.toString();
    }

    public static class Builder {
        public ResourceLocation potion;
        public int level;
        public int duration;
        public float health;
        public float chance;
        public ResourceLocation sound;
        public List<Integer> dimensions = new ArrayList<Integer>();
        public boolean blockDimensions;
        public String damageType;

        Builder() {
        }

        public Builder potion(ResourceLocation potion) {
            this.potion = potion;
            return this;
        }

        public Builder level(int level) {
            this.level = level;
            return this;
        }

        public Builder duration(int duration) {
            this.duration = duration * 20;
            return this;
        }

        public Builder health(float health) {
            this.health = health / 100.0f;
            return this;
        }

        public Builder chance(float chance) {
            this.chance = chance / 100.0f;
            return this;
        }

        public Builder sound(ResourceLocation sound) {
            this.sound = sound;
            return this;
        }

        public Builder dimension(int dimId) {
            this.dimensions.add(dimId);
            return this;
        }

        public Builder blockDimensions(boolean blockDimensions) {
            this.blockDimensions = blockDimensions;
            return this;
        }

        public Builder damageType(String damageType) {
            this.damageType = damageType;
            return this;
        }

        public MobOffenseType build() {
            return new MobOffenseType(this.potion, this.level, this.duration, this.health, this.chance, this.sound, this.dimensions, this.blockDimensions, this.damageType);
        }
    }
}

