/*
 * Decompiled with CFR 0.152.
 */
package quarris.rotm.config.types;

import net.minecraft.util.ResourceLocation;

public class HealthRegainType {
    public final ResourceLocation target;
    public final float healthPercentage;
    public final boolean lastManStanding;
    public final float radius;

    public HealthRegainType(ResourceLocation target, float healthPercentage, boolean lastManStanding, float radius) {
        this.target = target;
        this.healthPercentage = healthPercentage;
        this.lastManStanding = lastManStanding;
        this.radius = radius;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HealthRegainType{");
        sb.append("target=").append(this.target);
        sb.append(", healthPercentage=").append(this.healthPercentage);
        sb.append(", lastManStanding=").append(this.lastManStanding);
        sb.append(", radius=").append(this.radius);
        sb.append('}');
        return sb.toString();
    }

    public static class Builder {
        public ResourceLocation target;
        public float healthPercentage;
        public boolean lastManStanding;
        public float radius;

        public Builder target(ResourceLocation target) {
            this.target = target;
            return this;
        }

        public Builder healthPercentage(float healthPercentage) {
            this.healthPercentage = healthPercentage / 100.0f;
            return this;
        }

        public Builder lastManStanding(boolean lastManStanding) {
            this.lastManStanding = lastManStanding;
            return this;
        }

        public Builder radius(float radius) {
            this.radius = radius;
            return this;
        }

        public HealthRegainType build() {
            return new HealthRegainType(this.target, this.healthPercentage, this.lastManStanding, this.radius);
        }
    }
}

