/*
 * Decompiled with CFR 0.152.
 */
package quarris.rotm.config.types;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class DeathSpawnType {
    public final ResourceLocation summon;
    public final int minSpawn;
    public final int maxSpawn;
    public final boolean disableXP;
    public final boolean disableLoot;
    public final boolean autoAggro;
    public final ResourceLocation sound;
    public final NBTTagCompound nbt;
    public final float chance;

    public DeathSpawnType(ResourceLocation summon, int minSpawn, int maxSpawn, boolean disableXP, boolean disableLoot, boolean autoAggro, ResourceLocation sound, NBTTagCompound nbt, float chance) {
        this.summon = summon;
        this.minSpawn = minSpawn;
        this.maxSpawn = maxSpawn;
        this.disableXP = disableXP;
        this.disableLoot = disableLoot;
        this.autoAggro = autoAggro;
        this.sound = sound;
        this.nbt = nbt;
        this.chance = chance;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DeathSummonType{");
        sb.append("summon=").append(this.summon);
        sb.append(", minSpawn=").append(this.minSpawn);
        sb.append(", maxSpawn=").append(this.maxSpawn);
        sb.append(", disableXP=").append(this.disableXP);
        sb.append(", disableLoot=").append(this.disableLoot);
        sb.append(", sound=").append(this.sound);
        sb.append(", nbt=").append(this.nbt);
        sb.append(", chance=").append(this.chance);
        sb.append('}');
        return sb.toString();
    }

    public static class Builder {
        public ResourceLocation summon;
        public int minSpawn;
        public int maxSpawn;
        public boolean disableXP;
        public boolean disableLoot;
        public ResourceLocation sound;
        public NBTTagCompound nbt;
        public boolean autoAggro;
        public float chance;

        Builder() {
        }

        public Builder summon(ResourceLocation summon) {
            this.summon = summon;
            return this;
        }

        public Builder minSpawn(int minSpawn) {
            this.minSpawn = minSpawn;
            return this;
        }

        public Builder maxSpawn(int maxSpawn) {
            this.maxSpawn = maxSpawn;
            return this;
        }

        public Builder disableXP(boolean disableXP) {
            this.disableXP = disableXP;
            return this;
        }

        public Builder disableLoot(boolean disableLoot) {
            this.disableLoot = disableLoot;
            return this;
        }

        public Builder autoAggro(boolean autoAggro) {
            this.autoAggro = autoAggro;
            return this;
        }

        public Builder sound(ResourceLocation sound) {
            this.sound = sound;
            return this;
        }

        public Builder nbt(NBTTagCompound nbt) {
            this.nbt = nbt;
            return this;
        }

        public Builder chance(float chance) {
            this.chance = chance / 100.0f;
            return this;
        }

        public DeathSpawnType build() {
            return new DeathSpawnType(this.summon, this.minSpawn, this.maxSpawn, this.disableXP, this.disableLoot, this.autoAggro, this.sound, this.nbt, this.chance);
        }
    }
}

