/*
 * Decompiled with CFR 0.152.
 */
package quarris.rotm.config;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.Loader;
import quarris.rotm.ROTM;
import quarris.rotm.config.ISubConfig;
import quarris.rotm.config.utils.StringConfig;
import quarris.rotm.config.utils.StringConfigException;
import quarris.rotm.utils.Settable;
import quarris.rotm.utils.Utils;

public class VehicleConfig
implements ISubConfig {
    @Config.Name(value="Cancel Vehicle Mounting")
    @Config.Comment(value={"Allows you to prevent entities to mount these vehicle.", "You can block specific vehicle entities or entire mods.", "Format: <modid:vehicle> OR <modid>", "Where: <modid:vehicle> is the entity vehicle to disallow.", "<modid> is the modid name of the mod to disallow vehicles from."})
    public String[] rawVehicleCancels = new String[0];
    @Config.Ignore
    public Set<ResourceLocation> vehicleEntityCancels = new HashSet<ResourceLocation>();
    @Config.Ignore
    public Set<String> vehicleModCancels = new HashSet<String>();
    @Config.Name(value="Cancel Vehicle Mounting Overrides")
    @Config.Comment(value={"This allows vehicles to be excluded from the Cancel Vehicle Mounting config.", "You can put the vehicle entity (to override a mod vehicle cancel) or a vehicle;entity pair (to override a specific vehicle cancel).", "Format: <modid:vehicle> OR <modid:vehicle>;<modid:entity>", "Where: <modid:vehicle> is the vehicle to override.", "<modid:entity> is the entity to override from the vehicle"})
    public String[] rawVehicleCancelOverrides = new String[0];
    @Config.Ignore
    public SetMultimap<ResourceLocation, ResourceLocation> vehicleCancelOverrides = HashMultimap.create();
    @Config.Name(value="Global Cancel Vehicle Mounting Overrides")
    @Config.Comment(value={"This allows the passanger entities to be excluded globally from the Cancel Vehicle Mounting config.", "Format: <modid:entity>", "Where: <modid:entity> is the entity to globally exclude from the Cancel Vehicle Mounting."})
    public String[] rawGlobalCancelOverrides = new String[0];
    @Config.Ignore
    public Set<ResourceLocation> globalCancelOverrides = new HashSet<ResourceLocation>();
    @Config.Comment(value={"Should the Cancel Vehicle Mounting list be treated as a blocklist instead"})
    public boolean treatAtBlocklist = true;

    @Override
    public void onConfigChanged() {
        ResourceLocation res;
        this.vehicleEntityCancels.clear();
        this.vehicleModCancels.clear();
        this.vehicleCancelOverrides.clear();
        this.globalCancelOverrides.clear();
        for (String s : this.rawVehicleCancels) {
            res = new ResourceLocation(s);
            if (Utils.doesEntityExist(res)) {
                this.vehicleEntityCancels.add(res);
                continue;
            }
            if (Loader.isModLoaded((String)s)) {
                this.vehicleModCancels.add(s);
                continue;
            }
            ROTM.logger.warn("Could not parse config; skipping {}", (Object)s);
        }
        for (String s : this.rawVehicleCancelOverrides) {
            Settable vehicle = Settable.create();
            Settable entity = Settable.create();
            try {
                new StringConfig(s).next().parseAs(ResourceLocation::new).validate(Utils::doesEntityExist).accept(vehicle::set).next().optional(null).parseAs(ResourceLocation::new).validate(Utils::doesEntityExist).accept(entity::set);
                this.vehicleCancelOverrides.put(vehicle.get(), entity.get());
            }
            catch (StringConfigException e) {
                ROTM.logger.warn("Could not parse config; skipping {}", (Object)s);
            }
        }
        for (String s : this.rawGlobalCancelOverrides) {
            res = new ResourceLocation(s);
            if (Utils.doesEntityExist(res)) {
                this.globalCancelOverrides.add(res);
                continue;
            }
            ROTM.logger.warn("Could not parse config; skipping {}", (Object)s);
        }
    }
}

