/*
 * Decompiled with CFR 0.152.
 */
package quarris.rotm.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import quarris.rotm.ROTM;
import quarris.rotm.config.DebugConfig;
import quarris.rotm.config.EntityConfig;
import quarris.rotm.config.MiscConfig;
import quarris.rotm.config.VehicleConfig;

@Config(modid="rotm")
public class ModConfigs {
    @Config.Name(value="Entity Configurations")
    @Config.Comment(value={"These configs involve the changes to entities.", "Enable debug mode to get the names of potions, entities and potential damage sources", "For the player use \"minecraft:player\""})
    public static EntityConfig entityConfigs = new EntityConfig();
    @Config.Name(value="Vehicle Configurations")
    @Config.Comment(value={"These configs related to the use of entities as vehicles, such as minecarts or boats.", "For the player use \"minecraft:player\""})
    public static VehicleConfig vehicleConfigs = new VehicleConfig();
    @Config.Name(value="Miscellaneous Configurations")
    @Config.Comment(value={"These are misc configs.", "For the player use \"minecraft:player\""})
    public static MiscConfig miscConfigs = new MiscConfig();
    @Config.RequiresMcRestart
    @Config.Name(value="Debug Configurations")
    @Config.Comment(value={"This mod uses a variety of different aspects of the game which require internal names.", "These configs allow you to get those names to use in the configs."})
    public static DebugConfig debugConfigs = new DebugConfig();

    public static void updateConfigs() {
        ROTM.logger.info("Updating configs for {}", (Object)"Rebirth of the Mobs");
        entityConfigs.onConfigChanged();
        debugConfigs.onConfigChanged();
        vehicleConfigs.onConfigChanged();
        miscConfigs.onConfigChanged();
    }

    @Mod.EventBusSubscriber(modid="rotm")
    public static class EventHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("rotm")) {
                ConfigManager.sync((String)"rotm", (Config.Type)Config.Type.INSTANCE);
                ModConfigs.updateConfigs();
            }
        }
    }
}

