/*
 * Decompiled with CFR 0.152.
 */
package quarris.rotm.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import org.apache.commons.lang3.tuple.MutablePair;
import quarris.rotm.ROTM;
import quarris.rotm.config.ISubConfig;
import quarris.rotm.config.utils.StringConfig;
import quarris.rotm.config.utils.StringConfigException;
import quarris.rotm.utils.Utils;

public class MiscConfig
implements ISubConfig {
    @Config.Comment(value={"This multiplier is applied to all entities when they swim that are not on the blocklist."})
    public float globalSwimSpeedMultiplier = 1.0f;
    @Config.Comment(value={"This blocklist prevents the given entities from receiving the Global Swim Speed Multiplier"})
    public String[] rawGlobalSwimSpeedBlocklist = new String[0];
    @Config.Ignore
    public final List<ResourceLocation> globalSwimSpeedBlocklist = new ArrayList<ResourceLocation>();
    @Config.Comment(value={"Uses the rawGlobalSwimSpeedBlocklist as an allowlist instead"})
    public boolean treatGlobalSwimSpeedAsAllowlist = false;
    @Config.Comment(value={"This multiplier increases the swim speed for the specified entity by a specified amount. It stacks with the global speed multiplier.", "Format: <modid:entity>;<multiplier>", "Where: <modid:entity> is the entity to apply the multiplier for, and", "<multiplier> is the value to multiply the speed by."})
    public String[] rawSwimSpeedMultipliers = new String[0];
    @Config.Ignore
    public final Map<ResourceLocation, Float> swimSpeedMultipliers = new HashMap<ResourceLocation, Float>();
    @Config.RequiresMcRestart
    @Config.Comment(value={"This config allows natural spawns on most solid blocks such as slabs or stairs."})
    public boolean naturalSpawnBuff = false;

    @Override
    public void onConfigChanged() {
        this.updateGlobalSwimSpeedList();
        this.updateSwimSpeedList();
    }

    private void updateGlobalSwimSpeedList() {
        this.globalSwimSpeedBlocklist.clear();
        for (String s : this.rawGlobalSwimSpeedBlocklist) {
            try {
                new StringConfig(s).next().parseAs(ResourceLocation::new).validate(Utils::doesEntityExist).accept(this.globalSwimSpeedBlocklist::add);
            }
            catch (StringConfigException e) {
                ROTM.logger.warn("Could not parse config; skipping {}\n{}", (Object)s, (Object)e.getLocalizedMessage());
            }
        }
    }

    private void updateSwimSpeedList() {
        this.swimSpeedMultipliers.clear();
        for (String s : this.rawSwimSpeedMultipliers) {
            try {
                MutablePair pair = new MutablePair();
                new StringConfig(s).next().parseAs(ResourceLocation::new).validate(Utils::doesEntityExist).accept(arg_0 -> ((MutablePair)pair).setLeft(arg_0)).next().parseAs(Float::parseFloat).accept(arg_0 -> ((MutablePair)pair).setRight(arg_0));
                this.swimSpeedMultipliers.put((ResourceLocation)pair.left, (Float)pair.right);
            }
            catch (StringConfigException e) {
                ROTM.logger.warn("Could not parse config; skipping {}\n{}", (Object)s, (Object)e.getLocalizedMessage());
            }
        }
    }
}

