/*
 * Decompiled with CFR 0.152.
 */
package quarris.rotm.commands;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CommandDumpRegistry<T extends IForgeRegistryEntry<T>>
extends CommandBase {
    public String commandName;
    public IForgeRegistry<T> registry;

    public CommandDumpRegistry(String commandName, IForgeRegistry<T> registry) {
        this.commandName = commandName;
        this.registry = registry;
    }

    public String func_71517_b() {
        return this.commandName;
    }

    public String func_71518_a(ICommandSender sender) {
        return "Usage: /" + this.commandName;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        File dumpFile = server.func_71209_f(this.commandName + ".log");
        if (!dumpFile.exists()) {
            try {
                dumpFile.createNewFile();
            }
            catch (IOException e) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Could not create the dump file!"));
                e.printStackTrace();
                return;
            }
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(dumpFile));
            for (ResourceLocation name : this.registry.getKeys()) {
                writer.write(name.toString());
                writer.newLine();
            }
            sender.func_145747_a((ITextComponent)new TextComponentString("Dumped registry keys to " + dumpFile.getPath()));
            writer.close();
        }
        catch (IOException e) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            }
            e.printStackTrace();
        }
    }
}

