/*
 * Decompiled with CFR 0.152.
 */
package quarris.rotm.capability;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import quarris.rotm.config.ModConfigs;
import quarris.rotm.config.types.SummonSpawnType;
import quarris.rotm.utils.Utils;

public class SpawnSummonsCap
implements ICapabilitySerializable<NBTTagCompound> {
    @CapabilityInject(value=SpawnSummonsCap.class)
    public static Capability<SpawnSummonsCap> instance;
    public final EntityLivingBase entity;
    public final Table<ResourceLocation, Integer, SummonSpawn> spawns;

    public static void register() {
        CapabilityManager.INSTANCE.register(SpawnSummonsCap.class, (Capability.IStorage)new Capability.IStorage<SpawnSummonsCap>(){

            @Nullable
            public NBTBase writeNBT(Capability<SpawnSummonsCap> capability, SpawnSummonsCap instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<SpawnSummonsCap> capability, SpawnSummonsCap instance, EnumFacing side, NBTBase nbt) {
            }
        }, () -> null);
    }

    public SpawnSummonsCap(EntityLivingBase entity) {
        this.entity = entity;
        this.spawns = HashBasedTable.create();
        ModConfigs.entityConfigs.summonSpawns.get((Object)EntityList.func_191301_a((Entity)entity)).stream().filter(Objects::nonNull).forEach(entry -> {
            SummonSpawn cfr_ignored_0 = (SummonSpawn)this.spawns.put((Object)entry.summon, (Object)entry.id, (Object)new SummonSpawn((SummonSpawnType)entry, entity.field_70170_p.func_82737_E()));
        });
    }

    public void update() {
        for (SummonSpawn summonSpawn : this.spawns.values()) {
            summonSpawn.updateSummonList();
            summonSpawn.attemptSpawn();
        }
    }

    public void despawnSummons() {
        for (SummonSpawn summonSpawn : this.spawns.values()) {
            summonSpawn.despawnSummons();
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (Table.Cell cell : this.spawns.cellSet()) {
            NBTTagCompound summonSpawnNBT = new NBTTagCompound();
            summonSpawnNBT.func_74778_a("StringID", ((ResourceLocation)cell.getRowKey()).toString());
            summonSpawnNBT.func_74768_a("IntID", ((Integer)cell.getColumnKey()).intValue());
            summonSpawnNBT.func_74782_a("SummonData", (NBTBase)((SummonSpawn)cell.getValue()).serializeNBT());
            list.func_74742_a((NBTBase)summonSpawnNBT);
        }
        nbt.func_74782_a("SummonSpawns", (NBTBase)list);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("SummonSpawns", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound summonNbt = list.func_150305_b(i);
            ResourceLocation stringID = new ResourceLocation(summonNbt.func_74779_i("StringID"));
            int intID = summonNbt.func_74762_e("IntID");
            NBTTagCompound summonData = summonNbt.func_74775_l("SummonData");
            if (!this.spawns.contains((Object)stringID, (Object)intID)) continue;
            ((SummonSpawn)this.spawns.get((Object)stringID, (Object)intID)).deserializeNBT(summonData);
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == instance;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == instance) {
            return (T)this;
        }
        return null;
    }

    public class SummonSpawn
    implements INBTSerializable<NBTTagCompound> {
        public final Random random = new Random();
        public final SummonSpawnType entry;
        private long nextSpawnTime;
        private int totalSpawned;
        private final List<UUID> summonedEntities;
        private final List<UUID> attemptedSummons;
        private boolean madeSound;

        public SummonSpawn(SummonSpawnType entry, long time) {
            this.entry = entry;
            this.nextSpawnTime = time;
            this.summonedEntities = new LinkedList<UUID>();
            this.attemptedSummons = new LinkedList<UUID>();
        }

        public boolean canSpawn(World world, EntityLivingBase master) {
            if (world.func_82737_E() >= this.nextSpawnTime && master.func_110143_aJ() / master.func_110138_aP() <= this.entry.health && (this.entry.bypassMaxSpawns || this.summonedEntities.size() < this.entry.maxSpawn) && (this.entry.cap <= 0 || this.totalSpawned < this.entry.cap)) {
                return !this.entry.requireTarget || !(master instanceof EntityLiving) || ((EntityLiving)master).func_70638_az() != null;
            }
            return false;
        }

        public int getNextSpawnAmount() {
            int nextRandom = this.entry.minSpawn + this.random.nextInt(this.entry.maxSpawn - this.entry.minSpawn + 1);
            if (!this.entry.bypassMaxSpawns) {
                int currentCount = this.summonedEntities.size();
                if (currentCount < this.entry.maxSpawn) {
                    int toSpawn = Math.max(nextRandom, this.entry.maxSpawn - currentCount);
                    if (this.entry.cap > 0) {
                        return Math.min(toSpawn, this.entry.cap - this.totalSpawned);
                    }
                    return toSpawn;
                }
                return 0;
            }
            if (this.entry.cap > 0) {
                return Math.min(nextRandom, this.entry.cap - this.totalSpawned);
            }
            return nextRandom;
        }

        public void setRandomCooldownFrom(long time) {
            long cooldown = this.entry.minCooldownTicks + this.random.nextInt(this.entry.maxCooldownTicks - this.entry.minCooldownTicks + 1);
            this.nextSpawnTime = time + cooldown;
        }

        public void updateSummonList() {
            int i;
            EntityLivingBase master = SpawnSummonsCap.this.entity;
            World world = master.field_70170_p;
            boolean spawned = false;
            for (i = this.attemptedSummons.size() - 1; i >= 0; --i) {
                UUID attemptedSummonUUID = this.attemptedSummons.get(i);
                if (!world.field_72996_f.stream().anyMatch(e -> attemptedSummonUUID.equals(e.func_110124_au()))) continue;
                spawned = true;
                this.summonedEntities.add(attemptedSummonUUID);
                ++this.totalSpawned;
            }
            if (spawned) {
                if (this.entry.sound != null && !this.madeSound) {
                    world.func_184133_a(null, master.func_180425_c(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(this.entry.sound), SoundCategory.HOSTILE, 1.0f, 1.0f);
                }
                this.setRandomCooldownFrom(master.field_70170_p.func_82737_E());
            }
            this.attemptedSummons.clear();
            for (i = this.summonedEntities.size() - 1; i >= 0; --i) {
                UUID summonedUUID = this.summonedEntities.get(i);
                if (SpawnSummonsCap.this.entity.field_70170_p.field_72996_f.stream().anyMatch(e -> summonedUUID.equals(e.func_110124_au()))) continue;
                this.summonedEntities.remove(i);
            }
            this.madeSound = false;
        }

        public void attemptSpawn() {
            EntityLivingBase master = SpawnSummonsCap.this.entity;
            if (!master.field_70170_p.field_72995_K && this.canSpawn(master.field_70170_p, master)) {
                int amount = this.getNextSpawnAmount();
                boolean spawned = false;
                for (int i = 0; i < amount; ++i) {
                    Entity toSpawn = EntityList.func_188429_b((ResourceLocation)this.entry.summon, (World)master.field_70170_p);
                    if (toSpawn == null) continue;
                    if (toSpawn instanceof EntityLiving) {
                        ((EntityLiving)toSpawn).func_180482_a(master.field_70170_p.func_175649_E(toSpawn.func_180425_c()), null);
                    }
                    toSpawn.deserializeNBT(this.entry.nbt);
                    if (this.entry.disableLoot) {
                        toSpawn.getEntityData().func_74757_a("DisableXP", true);
                    }
                    if (this.entry.disableXP) {
                        toSpawn.getEntityData().func_74757_a("DisableLoot", true);
                    }
                    if (toSpawn instanceof EntityLiving && master instanceof EntityLiving && this.entry.autoAggro) {
                        ((EntityLiving)toSpawn).func_70624_b(((EntityLiving)master).func_70638_az());
                    }
                    int tries = 50;
                    for (int j = 0; j < tries; ++j) {
                        toSpawn.func_70012_b(master.field_70165_t + (double)(this.random.nextFloat() * 8.0f) - 4.0, master.field_70163_u + (double)this.random.nextInt(5) - 2.0, master.field_70161_v + (double)(this.random.nextFloat() * 8.0f) - 4.0, this.random.nextFloat() * 360.0f, 0.0f);
                        if (Utils.isEntityInCollision(master.field_70170_p, toSpawn) || !master.field_70170_p.func_72838_d(toSpawn)) continue;
                        spawned = true;
                        this.summonedEntities.add(toSpawn.func_110124_au());
                        ++this.totalSpawned;
                        break;
                    }
                    this.attemptedSummons.add(toSpawn.func_110124_au());
                }
                if (spawned) {
                    if (this.entry.sound != null) {
                        master.field_70170_p.func_184133_a(null, master.func_180425_c(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(this.entry.sound), SoundCategory.HOSTILE, 1.0f, 1.0f);
                        this.madeSound = true;
                    }
                    this.setRandomCooldownFrom(master.field_70170_p.func_82737_E());
                }
            }
        }

        public void despawnSummons() {
            EntityLivingBase master = SpawnSummonsCap.this.entity;
            List loadedEntityList = master.field_70170_p.field_72996_f;
            for (int i = 0; i < loadedEntityList.size(); ++i) {
                Entity e = (Entity)loadedEntityList.get(i);
                if (e.field_70128_L || !this.summonedEntities.contains(e.func_110124_au())) continue;
                e.func_70106_y();
            }
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            NBTTagList summonedList = new NBTTagList();
            for (UUID uuid : this.summonedEntities) {
                summonedList.func_74742_a((NBTBase)NBTUtil.func_186862_a((UUID)uuid));
            }
            nbt.func_74782_a("SummonedList", (NBTBase)summonedList);
            nbt.func_74772_a("NextSpawnTime", this.nextSpawnTime);
            nbt.func_74768_a("TotalSpawned", this.totalSpawned);
            return nbt;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.summonedEntities.clear();
            NBTTagList summonedList = nbt.func_150295_c("SummonedList", 10);
            for (int i = 0; i < summonedList.func_74745_c(); ++i) {
                this.summonedEntities.add(NBTUtil.func_186860_b((NBTTagCompound)summonedList.func_150305_b(i)));
            }
            this.nextSpawnTime = nbt.func_74763_f("NextSpawnTime");
            this.totalSpawned = nbt.func_74762_e("TotalSpawned");
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("SummonSpawn{");
            sb.append("entry=").append(this.entry);
            sb.append('}');
            return sb.toString();
        }
    }
}

