/*
 * Decompiled with CFR 0.152.
 */
package quarris.rotm;

import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;
import quarris.rotm.capability.SpawnSummonsCap;
import quarris.rotm.commands.CommandDumpRegistry;
import quarris.rotm.config.ModConfigs;
import quarris.rotm.items.ItemDebug;
import quarris.rotm.items.ModItems;
import quarris.rotm.proxy.CommonProxy;
import quarris.rotm.utils.Utils;

@Mod(modid="rotm", name="Rebirth of the Mobs", version="1.1.4", acceptedMinecraftVersions="[1.12.2]")
public class ROTM {
    public static final String MODID = "rotm";
    public static final String NAME = "Rebirth of the Mobs";
    public static final String VERSION = "1.1.4";
    public static Logger logger;
    @SidedProxy(clientSide="quarris.rotm.proxy.ClientProxy", serverSide="quarris.rotm.proxy.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        logger.info("Loading ROTM");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        SpawnSummonsCap.register();
        proxy.registerItemModels();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModConfigs.updateConfigs();
        if (ModConfigs.miscConfigs.naturalSpawnBuff) {
            ObfuscationReflectionHelper.setPrivateValue(EntityLiving.SpawnPlacementType.class, (Object)EntityLiving.SpawnPlacementType.ON_GROUND, Utils::canEntitySpawn, (String)"spawnPredicate");
        }
    }

    @Mod.EventHandler
    public void initCommands(FMLServerStartingEvent event) {
        if (ModConfigs.debugConfigs.enableDebugMode) {
            event.registerServerCommand(new CommandDumpRegistry("dumpEntities", ForgeRegistries.ENTITIES));
            event.registerServerCommand(new CommandDumpRegistry("dumpSounds", ForgeRegistries.SOUND_EVENTS));
            event.registerServerCommand(new CommandDumpRegistry("dumpPotions", ForgeRegistries.POTIONS));
        }
    }

    @Mod.EventBusSubscriber
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerDebugItems(RegistryEvent.Register<Item> event) {
            if (ModConfigs.debugConfigs.enableDebugMode) {
                event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{ModItems.debugDamages = ((Item)new ItemDebug(ItemDebug.DebugType.DAMAGE).setRegistryName(new ResourceLocation(ROTM.MODID, "debug_damages"))).func_77655_b("debug_damages"), ModItems.debugEntities = ((Item)new ItemDebug(ItemDebug.DebugType.ENTITY).setRegistryName(new ResourceLocation(ROTM.MODID, "debug_entities"))).func_77655_b("debug_entities"), ModItems.debugPotions = ((Item)new ItemDebug(ItemDebug.DebugType.POTION).setRegistryName(new ResourceLocation(ROTM.MODID, "debug_potions"))).func_77655_b("debug_potions")});
            }
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public static void registerItemModels(ModelRegistryEvent event) {
            proxy.registerItemModels();
        }
    }
}

