/*
 * Decompiled with CFR 0.152.
 */
package org.hjson;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.hjson.HjsonOptions;
import org.hjson.IHjsonDsfProvider;
import org.hjson.JsonArray;
import org.hjson.JsonObject;

class NewHjsonParser {
    private final String buffer;
    private final Reader reader;
    private final StringBuilder captureBuffer;
    private final StringBuilder peek;
    private final boolean legacyRoot;
    private final IHjsonDsfProvider[] dsfProviders;
    private int index;
    private int line;
    private int lineOffset;
    private int current;
    private boolean capture;
    private static final int BUFFER_SIZE = 8192;

    NewHjsonParser(String string, HjsonOptions options) {
        if (options != null) {
            this.dsfProviders = options.getDsfProviders();
            this.legacyRoot = options.getParseLegacyRoot();
        } else {
            this.dsfProviders = new IHjsonDsfProvider[0];
            this.legacyRoot = true;
        }
        this.buffer = string;
        this.peek = new StringBuilder();
        this.captureBuffer = new StringBuilder();
        this.reader = new StringReader(string);
        this.index = 0;
        this.lineOffset = 0;
        this.current = 0;
        this.line = 1;
        this.capture = false;
    }

    NewHjsonParser(Reader reader, HjsonOptions options) throws IOException {
        this(NewHjsonParser.readToEnd(reader), options);
    }

    private static String readToEnd(Reader reader) throws IOException {
        int n;
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[8192];
        while ((n = reader.read(buffer, 0, 8192)) != -1) {
            sb.append(buffer, 0, n);
        }
        return sb.toString();
    }

    private static class ContainerData {
        private int lineLength = 1;
        private int sumLineLength = 0;
        private int numLines = 0;
        private boolean condensed;

        private ContainerData(boolean condensed) {
            this.condensed = condensed;
        }

        private void incrLineLength() {
            ++this.lineLength;
        }

        private void overrideCondensed() {
            this.condensed = false;
        }

        private void nl() {
            this.sumLineLength += this.lineLength;
            this.lineLength = 1;
            ++this.numLines;
        }

        private int finalLineLength(int size) {
            return this.sumLineLength > 0 ? this.avgLineLength() : (this.condensed ? size : 1);
        }

        private int avgLineLength() {
            int avgLineLength = this.sumLineLength / this.numLines;
            if (avgLineLength <= 0) {
                avgLineLength = 1;
            }
            return avgLineLength;
        }

        private JsonArray into(JsonArray array) {
            return array.setLineLength(this.finalLineLength(array.size())).setCondensed(this.condensed);
        }

        private JsonObject into(JsonObject object) {
            return object.setLineLength(this.finalLineLength(object.size())).setCondensed(this.condensed);
        }
    }
}

