/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.world.generator;

import com.personthecat.cavegenerator.data.RavineSettings;
import com.personthecat.cavegenerator.data.TunnelSettings;
import com.personthecat.cavegenerator.model.PrimerData;
import com.personthecat.cavegenerator.model.ScalableFloat;
import java.util.Random;
import net.minecraft.util.math.MathHelper;

public class TunnelPathInfo {
    private float yaw;
    private float pitch;
    private float dYaw;
    private float dPitch;
    private float scale;
    private float stretch;
    private float x;
    private float y;
    private float z;
    private final ScalableFloat sfYaw;
    private final ScalableFloat sfPitch;
    private final ScalableFloat sfdYaw;
    private final ScalableFloat sfdPitch;
    private final ScalableFloat sfScale;
    private final ScalableFloat sfStretch;
    private static final float PI_TIMES_2 = (float)Math.PI * 2;

    public TunnelPathInfo(TunnelSettings cfg, Random rand, int destChunkX, int destChunkZ) {
        this(cfg.yaw, cfg.pitch, cfg.dYaw, cfg.dPitch, cfg.scale, cfg.stretch, rand, destChunkX, destChunkZ, cfg.originHeight.min, cfg.originHeight.max);
    }

    public TunnelPathInfo(RavineSettings cfg, Random rand, int destChunkX, int destChunkZ) {
        this(cfg.yaw, cfg.pitch, cfg.dYaw, cfg.dPitch, cfg.scale, cfg.stretch, rand, destChunkX, destChunkZ, cfg.originHeight.min, cfg.originHeight.max);
    }

    private TunnelPathInfo(ScalableFloat yaw, ScalableFloat pitch, ScalableFloat dYaw, ScalableFloat dPitch, ScalableFloat scale, ScalableFloat stretch, Random rand, int destChunkX, int destChunkZ, int minHeight, int maxHeight) {
        this.yaw = yaw.startVal + yaw.startValRandFactor * (rand.nextFloat() * ((float)Math.PI * 2));
        this.pitch = pitch.startVal + pitch.startValRandFactor * (rand.nextFloat() - 0.5f);
        this.scale = scale.startVal + scale.startValRandFactor * (rand.nextFloat() * 2.0f + rand.nextFloat());
        this.dYaw = dYaw.startVal;
        this.dPitch = dPitch.startVal;
        this.stretch = stretch.startVal;
        this.sfYaw = yaw;
        this.sfPitch = pitch;
        this.sfdYaw = dYaw;
        this.sfdPitch = dPitch;
        this.sfScale = scale;
        this.sfStretch = stretch;
        int heightDiff = maxHeight - minHeight;
        this.x = destChunkX * 16 + rand.nextInt(16);
        this.y = rand.nextInt(rand.nextInt(heightDiff) + 2) + minHeight;
        this.z = destChunkZ * 16 + rand.nextInt(16);
    }

    private TunnelPathInfo(TunnelPathInfo from, float yaw, float pitch, float dYaw, float dPitch, float scale, float stretch, float x, float y, float z) {
        this.sfYaw = from.sfYaw;
        this.sfPitch = from.sfPitch;
        this.sfdYaw = from.sfdYaw;
        this.sfdPitch = from.sfdPitch;
        this.sfScale = from.sfScale;
        this.sfStretch = from.sfStretch;
        this.yaw = yaw;
        this.pitch = pitch;
        this.scale = scale;
        this.dYaw = dYaw;
        this.dPitch = dPitch;
        this.stretch = stretch;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public TunnelPathInfo reset(float angleXZ, float angleY, float scale, float scaleY) {
        return new TunnelPathInfo(this, angleXZ, angleY, this.sfdYaw.startVal, this.sfdPitch.startVal, scale, scaleY, this.x, this.y, this.z);
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getScale() {
        return this.scale;
    }

    public void multiplyScale(float by) {
        this.scale *= by;
    }

    public float getStretch() {
        return this.stretch;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void update(Random rand, boolean noiseYReduction, float angleYFactor, float twistPotential) {
        this.nextPos();
        if (noiseYReduction) {
            this.pitch *= angleYFactor;
        }
        this.updateVals(rand, twistPotential);
    }

    void nextPos() {
        float cosPitch = MathHelper.func_76134_b((float)this.pitch);
        float sinPitch = MathHelper.func_76126_a((float)this.pitch);
        this.x += MathHelper.func_76134_b((float)this.yaw) * cosPitch;
        this.y += sinPitch;
        this.z += MathHelper.func_76126_a((float)this.yaw) * cosPitch;
    }

    void updateVals(Random rand, float maxRotation) {
        this.yaw += this.dYaw * maxRotation;
        this.pitch += this.dPitch * maxRotation;
        this.dPitch = this.rotate(this.dPitch, rand, this.sfdPitch);
        this.dYaw = this.rotate(this.dYaw, rand, this.sfdYaw);
        this.scale = this.reScale(this.scale, rand, this.sfScale);
        this.stretch = this.reScale(this.stretch, rand, this.sfStretch);
    }

    private float rotate(float original, Random rand, ScalableFloat f) {
        original = (float)Math.pow(original, f.exponent);
        original *= f.factor;
        return original += f.randFactor * (rand.nextFloat() - rand.nextFloat()) * rand.nextFloat();
    }

    private float reScale(float original, Random rand, ScalableFloat f) {
        original = (float)Math.pow(original, f.exponent);
        if ((original *= f.factor) < 0.0f) {
            original = 0.0f;
        }
        return original;
    }

    public boolean travelledTooFar(PrimerData data, int currentPos, int distance) {
        double fromCenterX = this.x - (float)data.centerX;
        double fromCenterX2 = fromCenterX * fromCenterX;
        double fromCenterZ = this.z - (float)data.centerZ;
        double fromCenterZ2 = fromCenterZ * fromCenterZ;
        double distanceRemaining = distance - currentPos;
        double distanceRemaining2 = distanceRemaining * distanceRemaining;
        double adjustedScale = (double)this.scale + 18.0;
        double adjustedScale2 = adjustedScale * adjustedScale;
        return fromCenterX2 + fromCenterZ2 - distanceRemaining2 > adjustedScale2;
    }

    public boolean touchesChunk(PrimerData data, double diameterXZ) {
        return (double)this.x >= (double)data.centerX - 16.0 - diameterXZ && (double)this.z >= (double)data.centerZ - 16.0 - diameterXZ && (double)this.x <= (double)data.centerX + 16.0 + diameterXZ && (double)this.z <= (double)data.centerZ + 16.0 + diameterXZ;
    }
}

