/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.world.generator;

import com.personthecat.cavegenerator.config.ConfigFile;
import com.personthecat.cavegenerator.data.CavernSettings;
import com.personthecat.cavegenerator.data.NoiseMapSettings;
import com.personthecat.cavegenerator.data.NoiseSettings;
import com.personthecat.cavegenerator.model.Range;
import com.personthecat.cavegenerator.noise.DummyGenerator;
import com.personthecat.cavegenerator.util.PositionFlags;
import com.personthecat.cavegenerator.world.BiomeSearch;
import com.personthecat.cavegenerator.world.generator.PrimerContext;
import com.personthecat.cavegenerator.world.generator.TunnelSocket;
import com.personthecat.cavegenerator.world.generator.WorldCarver;
import fastnoise.FastNoise;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class CavernGenerator
extends WorldCarver
implements TunnelSocket {
    private final List<ChunkTestData> invalidChunks;
    private final double[] wallNoise = new double[256];
    private final List<FastNoise> generators;
    private final FastNoise wallOffset;
    private final FastNoise heightOffset;
    private final PositionFlags caverns;
    private final double wallCurveRatio;
    private final boolean wallInterpolated;
    private final int maxY;
    private final int diffY;
    private final int curveOffset;
    protected final CavernSettings cfg;

    public CavernGenerator(CavernSettings cfg, World world) {
        super(cfg.conditions, cfg.decorators, world);
        this.generators = CavernGenerator.createGenerators(cfg.generators, world);
        this.wallOffset = cfg.wallOffset.map(n -> n.getGenerator(world)).orElse(new DummyGenerator(0.0f));
        this.heightOffset = cfg.offset.map(n -> n.getGenerator(world)).orElse(new DummyGenerator(0.0f));
        this.wallCurveRatio = cfg.wallCurveRatio;
        this.wallInterpolated = cfg.wallInterpolation;
        int minY = this.conditions.height.min + cfg.conditions.floor.map(n -> n.range.min).orElse(0);
        this.maxY = this.conditions.height.max + cfg.conditions.ceiling.map(n -> n.range.max).orElse(0);
        this.diffY = this.maxY - minY;
        this.caverns = new PositionFlags(256 * this.maxY - minY);
        this.curveOffset = (this.diffY + 1) / -2;
        int r = BiomeSearch.size();
        this.invalidChunks = new ArrayList<ChunkTestData>(this.wallInterpolated ? (r * 2 + 1) * 2 - 1 : r);
        if (cfg.walls.isPresent()) {
            this.setupWallNoise(cfg.walls.get(), world);
        } else {
            Arrays.fill(this.wallNoise, 15.0);
        }
        this.cfg = cfg;
    }

    private static List<FastNoise> createGenerators(List<NoiseSettings> settings, World world) {
        return settings.stream().map(s -> s.getGenerator(world)).collect(Collectors.toList());
    }

    private void setupWallNoise(NoiseMapSettings settings, World world) {
        FastNoise noise = settings.getGenerator(world);
        int len = this.wallNoise.length;
        double increment = 6.2830810546 / (double)len;
        int r = 32;
        for (int i = 0; i < len; ++i) {
            double angle = (double)(i + 1) * increment;
            int x = (int)(32.0 * Math.cos(angle));
            int y = (int)(32.0 * Math.sin(angle));
            this.wallNoise[i] = noise.GetAdjustedNoise(x, y);
        }
    }

    @Override
    public void generate(PrimerContext ctx) {
        if (this.conditions.dimensions.test(ctx.world.field_73011_w.getDimension())) {
            if (this.conditions.hasBiomes) {
                if (ctx.biomes.anyMatches(this.conditions.biomes)) {
                    this.fillInvalidChunks(ctx.biomes, ctx.chunkX, ctx.chunkZ);
                    this.generateChecked(ctx);
                    this.invalidChunks.clear();
                }
            } else if (this.conditions.hasRegion) {
                if (this.conditions.region.GetBoolean(ctx.offsetX, ctx.offsetZ)) {
                    this.fillInvalidChunks(ctx.chunkX, ctx.chunkZ);
                    this.generateChecked(ctx);
                    this.invalidChunks.clear();
                }
            } else {
                this.generateChecked(ctx);
            }
            this.caverns.reset();
        }
    }

    private void fillInvalidChunks(BiomeSearch biomes, int x, int z) {
        if (this.wallInterpolated) {
            this.fillInterpolated(biomes, x, z);
        } else {
            this.fillBorder(biomes);
        }
    }

    private void fillBorder(BiomeSearch biomes) {
        for (BiomeSearch.Data d : biomes.surrounding.get()) {
            if (this.conditions.biomes.test(d.biome) && this.conditions.region.GetBoolean(d.centerX, d.centerZ)) continue;
            int translateY = (int)this.wallOffset.GetAdjustedNoise(d.centerX, d.centerZ);
            this.invalidChunks.add(new ChunkTestData(d.centerX, d.centerZ, translateY));
        }
    }

    private void fillInterpolated(BiomeSearch biomes, int x, int z) {
        int r = ConfigFile.biomeRange;
        boolean[][] points = this.getBorderMatrix(biomes, r, x, z);
        CavernGenerator.interpolate(points);
        CavernGenerator.interpolate(points);
        CavernGenerator.createBorder(this.invalidChunks, points, this.wallOffset, r, x, z);
    }

    private boolean[][] getBorderMatrix(BiomeSearch biomes, int r, int x, int z) {
        int size = r * 2 + 1;
        int interpolated = size * 2 - 1;
        boolean[][] points = new boolean[interpolated][interpolated];
        for (BiomeSearch.Data d : biomes.surrounding.get()) {
            if (this.conditions.biomes.test(d.biome) && this.conditions.region.GetBoolean(d.centerX, d.centerZ)) continue;
            int relX = d.chunkX - x;
            int relZ = d.chunkZ - z;
            points[(relX + r) * 2][(relZ + r) * 2] = true;
        }
        return points;
    }

    private static void interpolate(boolean[][] f) {
        int len = f.length;
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < len; ++j) {
                if (f[i][j]) continue;
                if (i % 2 == 1 && j % 2 == 1) {
                    boolean nw = f[i - 1][j - 1];
                    boolean se = f[i + 1][j + 1];
                    boolean ne = f[i - 1][j + 1];
                    boolean sw = f[i + 1][j - 1];
                    f[i][j] = nw && se || ne && sw;
                    continue;
                }
                boolean n = i > 0 && f[i - 1][j];
                boolean s = i < len - 1 && f[i + 1][j];
                boolean e = j > 0 && f[i][j - 1];
                boolean w = j < len - 1 && f[i][j + 1];
                f[i][j] = n && s || e && w;
            }
        }
    }

    private static void createBorder(List<ChunkTestData> border, boolean[][] f, FastNoise noise, int r, int x, int z) {
        int len = f.length;
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < len; ++j) {
                if (!f[i][j]) continue;
                double cX = (double)i / 2.0 - (double)r + (double)x;
                double cZ = (double)j / 2.0 - (double)r + (double)z;
                int aX = (int)cX * 16 + 8 + (cX % 1.0 == 0.0 ? 8 : 0);
                int aZ = (int)cZ * 16 + 8 + (cZ % 1.0 == 0.0 ? 8 : 0);
                int translateY = (int)noise.GetAdjustedNoise(aX, aZ);
                border.add(new ChunkTestData(aX, aZ, translateY));
            }
        }
    }

    private void fillInvalidChunks(int chunkX, int chunkZ) {
        int range = ConfigFile.biomeRange;
        for (int cX = chunkX - range; cX <= chunkX + range; ++cX) {
            for (int cZ = chunkZ - range; cZ < chunkZ + range; ++cZ) {
                int centerX = cX * 16 + 8;
                int centerZ = cZ * 16 + 8;
                if (this.conditions.region.GetBoolean(centerX, centerZ)) continue;
                int translateY = (int)this.wallOffset.GetAdjustedNoise(centerX, centerZ);
                this.invalidChunks.add(new ChunkTestData(centerX, centerZ, translateY));
            }
        }
    }

    @Override
    protected void generateChecked(PrimerContext ctx) {
        this.generateCaverns(ctx.heightmap, ctx.localRand, ctx.world, ctx.primer, ctx.chunkX, ctx.chunkZ);
    }

    private void generateCaverns(int[][] heightmap, Random rand, World world, ChunkPrimer primer, int chunkX, int chunkZ) {
        for (int x = 0; x < 16; ++x) {
            int actualX = x + chunkX * 16;
            for (int z = 0; z < 16; ++z) {
                int actualZ = z + chunkZ * 16;
                this.generateColumn(heightmap, rand, primer, x, z, chunkX, chunkZ, actualX, actualZ);
            }
        }
        this.decorateAll(this.caverns, rand, world, primer, chunkX, chunkZ);
    }

    private void generateColumn(int[][] heightmap, Random rand, ChunkPrimer primer, int x, int z, int chunkX, int chunkZ, int actualX, int actualZ) {
        BorderData border = this.getNearestBorder(actualX, actualZ);
        double distance = border.distance;
        int offset = border.offset;
        Range height = this.conditions.getColumn(heightmap, actualX, actualZ);
        int d = (int)this.decorators.shell.radius;
        int min = Math.max(1, height.min - d);
        int max = Math.min(255, height.max + d);
        int yO = (int)this.heightOffset.GetAdjustedNoise(actualX, actualZ);
        for (int y = min; y < max; ++y) {
            if (!this.conditions.noise.GetBoolean(actualX, y + yO, actualZ)) continue;
            double relY = this.curveOffset + this.maxY - y;
            double curve = distance - relY * relY / (double)this.diffY * this.wallCurveRatio;
            double wall = this.wallNoise[y + offset & 0xFF];
            if (curve > wall) {
                this.place(rand, primer, height, x, y, z, yO, chunkX, chunkZ, actualX, actualZ);
                continue;
            }
            if (!(curve > wall - (double)d)) continue;
            this.generateShell(rand, primer, x, y, z, y, chunkX, chunkZ);
        }
    }

    private void place(Random rand, ChunkPrimer primer, Range height, int x, int y, int z, int yO, int chunkX, int chunkZ, int actualX, int actualZ) {
        for (FastNoise noise : this.generators) {
            float value;
            if (noise.IsInThreshold(value = noise.GetNoise(actualX, y + yO, actualZ))) {
                if (height.contains(y)) {
                    this.replaceBlock(rand, primer, x, y, z, chunkX, chunkZ);
                    this.caverns.add(x, y, z);
                } else {
                    this.generateShell(rand, primer, x, y, z, y, chunkX, chunkZ);
                }
                return;
            }
            if (!noise.IsOuter(value, this.decorators.shell.noiseThreshold)) continue;
            this.generateShell(rand, primer, x, y, z, y, chunkX, chunkZ);
        }
    }

    private BorderData getNearestBorder(int x, int z) {
        double shortestDistance = Double.MAX_VALUE;
        int offset = 0;
        for (ChunkTestData invalid : this.invalidChunks) {
            double sum = Math.pow(x - invalid.x, 2.0) + Math.pow(z - invalid.z, 2.0);
            double distance = Math.sqrt(sum);
            if (!(distance < shortestDistance)) continue;
            shortestDistance = distance;
            offset = invalid.offset;
        }
        return new BorderData(shortestDistance, offset);
    }

    private void decorateCaverns(Random rand, ChunkPrimer primer, int chunkX, int chunkZ) {
        this.caverns.forEach((x, y, z) -> this.decorateBlock(rand, primer, x, y, z, chunkX, chunkZ));
    }

    @Override
    protected void generateShell(Random rand, ChunkPrimer primer, int x, int y, int z, int cY, int chunkX, int chunkZ) {
        if (this.hasShell()) {
            super.generateShell(rand, primer, x, y, z, cY, chunkX, chunkZ);
        }
    }

    @Override
    public int getTunnelHeight(int[][] heightmap, Random rand, int x, int z, int chunkX, int chunkZ) {
        Range height = this.conditions.getColumn(x, z);
        if (height.isEmpty()) {
            return Integer.MIN_VALUE;
        }
        int center = height.rand(rand);
        int yO = (int)this.heightOffset.GetAdjustedNoise(x, z);
        if (rand.nextBoolean()) {
            for (int y = center; y < height.max; y += this.cfg.resolution) {
                if (!this.checkSingle(x, y + yO, z)) continue;
                return y;
            }
        } else {
            for (int y = center; y > height.min; y -= this.cfg.resolution) {
                if (!this.checkSingle(x, y + yO, z)) continue;
                return y;
            }
        }
        return Integer.MIN_VALUE;
    }

    private boolean checkSingle(int actualX, int y, int actualZ) {
        if (!this.conditions.noise.GetBoolean(actualX, y, actualZ)) {
            return false;
        }
        for (FastNoise generator : this.generators) {
            if (!generator.GetBoolean(actualX, y, actualZ)) continue;
            return true;
        }
        return false;
    }

    private static class BorderData {
        final double distance;
        final int offset;

        public BorderData(double distance, int offset) {
            this.distance = distance;
            this.offset = offset;
        }
    }

    private static class ChunkTestData {
        final int x;
        final int z;
        final int offset;

        public ChunkTestData(int x, int z, int offset) {
            this.x = x;
            this.z = z;
            this.offset = offset;
        }
    }
}

