/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.world.feature;

import com.personthecat.cavegenerator.data.PillarSettings;
import com.personthecat.cavegenerator.model.Range;
import com.personthecat.cavegenerator.world.feature.FeatureGenerator;
import com.personthecat.cavegenerator.world.feature.WorldContext;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

@ParametersAreNonnullByDefault
public class PillarGenerator
extends FeatureGenerator {
    private static final IBlockState BLK_AIR = Blocks.field_150350_a.func_176223_P();
    private final PillarSettings cfg;

    public PillarGenerator(PillarSettings cfg, World world) {
        super(cfg.conditions, world);
        this.cfg = cfg;
    }

    @Override
    protected void doGenerate(WorldContext ctx) {
        Random rand = ctx.rand;
        for (int i = 0; i < rand.nextInt(this.cfg.count + 1); ++i) {
            int y;
            int opening;
            Range height;
            int z;
            int x = rand.nextInt(6) * 2 + 2 + ctx.chunkX * 16;
            Biome biome = ctx.world.func_180494_b(new BlockPos(x, 0, z = rand.nextInt(6) * 2 + 1 + ctx.chunkZ * 16));
            if (!this.conditions.biomes.test(biome) || (height = this.conditions.getColumn(x, z)).isEmpty() || !this.conditions.region.GetBoolean(x, z) || (opening = this.findCeiling(ctx.world, x, y = height.rand(rand), z, height.max)) == Integer.MIN_VALUE || !this.conditions.noise.GetBoolean(x, opening, z)) continue;
            this.generateSingle(ctx.world, ctx.rand, new BlockPos(x, opening, z));
        }
    }

    private void generateSingle(World world, Random rand, BlockPos pos) {
        int actualMax = pos.func_177956_o();
        int actualMin = this.getLowestBlock(world, pos);
        if (actualMin < 0) {
            return;
        }
        int length = actualMax - actualMin;
        if (length < this.cfg.length.min || length > this.cfg.length.max) {
            return;
        }
        for (int y = actualMax; y >= actualMin; --y) {
            BlockPos current = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
            world.func_180501_a(current, this.cfg.state, 2);
            if (!this.cfg.stairBlock.isPresent()) continue;
            if (y == actualMax) {
                this.testPlaceStairs(world, this.cfg.stairBlock.get(), rand, pos, BlockStairs.EnumHalf.TOP);
                continue;
            }
            if (y != actualMin) continue;
            this.testPlaceStairs(world, this.cfg.stairBlock.get(), rand, current, BlockStairs.EnumHalf.BOTTOM);
        }
    }

    private int getLowestBlock(World world, BlockPos pos) {
        pos = pos.func_177977_b();
        while (pos.func_177956_o() > this.cfg.conditions.height.min) {
            if (world.func_180495_p(pos).func_185914_p()) {
                return pos.func_177956_o();
            }
            pos = pos.func_177977_b();
        }
        return -1;
    }

    private void testPlaceStairs(World world, BlockStairs stairs, Random rand, BlockPos pos, BlockStairs.EnumHalf topOrBottom) {
        if (topOrBottom.equals((Object)BlockStairs.EnumHalf.TOP)) {
            this.testPlaceUp(stairs, pos.func_177978_c(), EnumFacing.SOUTH, rand, world, topOrBottom);
            this.testPlaceUp(stairs, pos.func_177968_d(), EnumFacing.NORTH, rand, world, topOrBottom);
            this.testPlaceUp(stairs, pos.func_177974_f(), EnumFacing.WEST, rand, world, topOrBottom);
            this.testPlaceUp(stairs, pos.func_177976_e(), EnumFacing.EAST, rand, world, topOrBottom);
        } else {
            this.testPlaceDown(stairs, pos.func_177978_c(), EnumFacing.SOUTH, rand, world, topOrBottom);
            this.testPlaceDown(stairs, pos.func_177968_d(), EnumFacing.NORTH, rand, world, topOrBottom);
            this.testPlaceDown(stairs, pos.func_177974_f(), EnumFacing.WEST, rand, world, topOrBottom);
            this.testPlaceDown(stairs, pos.func_177976_e(), EnumFacing.EAST, rand, world, topOrBottom);
        }
    }

    private void testPlaceDown(BlockStairs stairs, BlockPos pos, EnumFacing facing, Random rand, World world, BlockStairs.EnumHalf topOrBottom) {
        BlockPos previous = pos.func_177979_c(4);
        for (int i = -3; i <= 3; ++i) {
            BlockPos current = pos.func_177981_b(i);
            if (current.func_177956_o() >= this.cfg.conditions.height.min && rand.nextInt(2) == 0 && world.func_180495_p(previous).func_185914_p() && world.func_180495_p(current).equals(BLK_AIR)) {
                world.func_180501_a(current, this.getStairRotation(stairs, facing, topOrBottom), 16);
                return;
            }
            previous = current;
        }
    }

    private void testPlaceUp(BlockStairs stairs, BlockPos pos, EnumFacing facing, Random rand, World world, BlockStairs.EnumHalf topOrBottom) {
        BlockPos previous = pos.func_177981_b(4);
        for (int i = 3; i >= -3; --i) {
            BlockPos current = pos.func_177981_b(i);
            if (current.func_177956_o() >= this.cfg.conditions.height.min && rand.nextInt(2) == 0 && world.func_180495_p(previous).func_185914_p() && world.func_180495_p(current).equals(BLK_AIR)) {
                world.func_180501_a(current, this.getStairRotation(stairs, facing, topOrBottom), 16);
                return;
            }
            previous = current;
        }
    }

    private IBlockState getStairRotation(BlockStairs stairs, EnumFacing facing, BlockStairs.EnumHalf topOrBottom) {
        return stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)facing).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)topOrBottom).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.STRAIGHT);
    }
}

