/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.world;

import com.personthecat.cavegenerator.config.CavePreset;
import com.personthecat.cavegenerator.data.BurrowSettings;
import com.personthecat.cavegenerator.data.CavernSettings;
import com.personthecat.cavegenerator.data.ClusterSettings;
import com.personthecat.cavegenerator.data.LayerSettings;
import com.personthecat.cavegenerator.data.PillarSettings;
import com.personthecat.cavegenerator.data.RavineSettings;
import com.personthecat.cavegenerator.data.StalactiteSettings;
import com.personthecat.cavegenerator.data.StructureSettings;
import com.personthecat.cavegenerator.data.TunnelSettings;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.world.feature.PillarGenerator;
import com.personthecat.cavegenerator.world.feature.StalactiteGenerator;
import com.personthecat.cavegenerator.world.feature.StructureGenerator;
import com.personthecat.cavegenerator.world.feature.WorldContext;
import com.personthecat.cavegenerator.world.generator.BurrowGenerator;
import com.personthecat.cavegenerator.world.generator.CavernGenerator;
import com.personthecat.cavegenerator.world.generator.ClusterGenerator;
import com.personthecat.cavegenerator.world.generator.LayerGenerator;
import com.personthecat.cavegenerator.world.generator.PrimerContext;
import com.personthecat.cavegenerator.world.generator.RavineGenerator;
import com.personthecat.cavegenerator.world.generator.TunnelConnector;
import com.personthecat.cavegenerator.world.generator.TunnelGenerator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.World;

public class GeneratorController {
    private final List<TunnelGenerator> tunnels;
    private final List<RavineGenerator> ravines;
    private final List<CavernGenerator> caverns;
    private final List<CavernGenerator> deferredCaverns;
    private final List<BurrowGenerator> burrows;
    private final List<LayerGenerator> layers;
    private final List<TunnelConnector<CavernGenerator>> cavernTunnels;
    private final List<TunnelConnector<BurrowGenerator>> burrowTunnels;
    private final ClusterGenerator globalClusters;
    private final ClusterGenerator layeredClusters;
    private final List<StalactiteGenerator> stalactites;
    private final List<PillarGenerator> pillars;
    private final List<StructureGenerator> structures;

    public static GeneratorController from(CavePreset preset, World world) {
        GeneratorControllerBuilder builder = GeneratorController.builder().tunnels(CommonMethods.map(preset.tunnels, t -> new TunnelGenerator((TunnelSettings)t, world))).ravines(CommonMethods.map(preset.ravines, r -> new RavineGenerator((RavineSettings)r, world))).layers(CommonMethods.map(preset.layers, l -> new LayerGenerator((LayerSettings)l, world))).stalactites(CommonMethods.map(preset.stalactites, s -> new StalactiteGenerator((StalactiteSettings)s, world))).pillars(CommonMethods.map(preset.pillars, p -> new PillarGenerator((PillarSettings)p, world))).structures(CommonMethods.map(preset.structures, s -> new StructureGenerator((StructureSettings)s, world)));
        GeneratorController.sortClusters(preset.clusters, world, builder);
        GeneratorController.mapCaverns(preset.caverns, world, builder);
        GeneratorController.mapBurrows(preset.burrows, world, builder);
        return builder.build();
    }

    private static void sortClusters(List<ClusterSettings> clusters, World world, GeneratorControllerBuilder builder) {
        ArrayList<ClusterSettings> global = new ArrayList<ClusterSettings>();
        ArrayList<ClusterSettings> layered = new ArrayList<ClusterSettings>();
        clusters.forEach(c -> (c.matchers.isEmpty() ? global : layered).add(c));
        builder.globalClusters(new ClusterGenerator(global, world)).layeredClusters(new ClusterGenerator(layered, world));
    }

    private static void mapCaverns(List<CavernSettings> caverns, World world, GeneratorControllerBuilder builder) {
        ArrayList<CavernGenerator> generators = new ArrayList<CavernGenerator>();
        ArrayList<CavernGenerator> deferred = new ArrayList<CavernGenerator>();
        ArrayList<TunnelConnector<CavernGenerator>> connectors = new ArrayList<TunnelConnector<CavernGenerator>>();
        for (CavernSettings cavern : caverns) {
            CavernGenerator generator = new CavernGenerator(cavern, world);
            (cavern.deferred ? deferred : generators).add(generator);
            cavern.branches.ifPresent(b -> connectors.add(new TunnelConnector<CavernGenerator>((TunnelSettings)b, generator, world)));
        }
        builder.caverns(generators);
        builder.deferredCaverns(deferred);
        builder.cavernTunnels(connectors);
    }

    private static void mapBurrows(List<BurrowSettings> burrows, World world, GeneratorControllerBuilder builder) {
        ArrayList<BurrowGenerator> generators = new ArrayList<BurrowGenerator>();
        ArrayList<TunnelConnector<BurrowGenerator>> connectors = new ArrayList<TunnelConnector<BurrowGenerator>>();
        for (BurrowSettings burrow : burrows) {
            BurrowGenerator generator = new BurrowGenerator(burrow, world);
            generators.add(generator);
            burrow.branches.ifPresent(b -> connectors.add(new TunnelConnector<BurrowGenerator>((TunnelSettings)b, generator, world)));
        }
        builder.burrows(generators);
        builder.burrowTunnels(connectors);
    }

    public void earlyGenerate(PrimerContext ctx) {
        this.globalClusters.generate(ctx);
        this.layers.forEach(l -> l.generate(ctx));
        this.layeredClusters.generate(ctx);
        this.caverns.forEach(c -> c.generate(ctx));
        this.burrows.forEach(t -> t.generate(ctx));
    }

    public void mapGenerate(PrimerContext ctx) {
        this.tunnels.forEach(t -> t.generate(ctx));
        this.ravines.forEach(r -> r.generate(ctx));
        this.cavernTunnels.forEach(t -> t.generate(ctx));
        this.burrowTunnels.forEach(t -> t.generate(ctx));
        this.deferredCaverns.forEach(c -> c.generate(ctx));
    }

    public void featureGenerate(WorldContext ctx) {
        this.pillars.forEach(p -> p.generate(ctx));
        this.stalactites.forEach(s -> s.generate(ctx));
        this.structures.forEach(s -> s.generate(ctx));
    }

    GeneratorController(List<TunnelGenerator> tunnels, List<RavineGenerator> ravines, List<CavernGenerator> caverns, List<CavernGenerator> deferredCaverns, List<BurrowGenerator> burrows, List<LayerGenerator> layers, List<TunnelConnector<CavernGenerator>> cavernTunnels, List<TunnelConnector<BurrowGenerator>> burrowTunnels, ClusterGenerator globalClusters, ClusterGenerator layeredClusters, List<StalactiteGenerator> stalactites, List<PillarGenerator> pillars, List<StructureGenerator> structures) {
        this.tunnels = tunnels;
        this.ravines = ravines;
        this.caverns = caverns;
        this.deferredCaverns = deferredCaverns;
        this.burrows = burrows;
        this.layers = layers;
        this.cavernTunnels = cavernTunnels;
        this.burrowTunnels = burrowTunnels;
        this.globalClusters = globalClusters;
        this.layeredClusters = layeredClusters;
        this.stalactites = stalactites;
        this.pillars = pillars;
        this.structures = structures;
    }

    public static GeneratorControllerBuilder builder() {
        return new GeneratorControllerBuilder();
    }

    public static class GeneratorControllerBuilder {
        private List<TunnelGenerator> tunnels;
        private List<RavineGenerator> ravines;
        private List<CavernGenerator> caverns;
        private List<CavernGenerator> deferredCaverns;
        private List<BurrowGenerator> burrows;
        private List<LayerGenerator> layers;
        private List<TunnelConnector<CavernGenerator>> cavernTunnels;
        private List<TunnelConnector<BurrowGenerator>> burrowTunnels;
        private ClusterGenerator globalClusters;
        private ClusterGenerator layeredClusters;
        private List<StalactiteGenerator> stalactites;
        private List<PillarGenerator> pillars;
        private List<StructureGenerator> structures;

        GeneratorControllerBuilder() {
        }

        public GeneratorControllerBuilder tunnels(List<TunnelGenerator> tunnels) {
            this.tunnels = tunnels;
            return this;
        }

        public GeneratorControllerBuilder ravines(List<RavineGenerator> ravines) {
            this.ravines = ravines;
            return this;
        }

        public GeneratorControllerBuilder caverns(List<CavernGenerator> caverns) {
            this.caverns = caverns;
            return this;
        }

        public GeneratorControllerBuilder deferredCaverns(List<CavernGenerator> deferredCaverns) {
            this.deferredCaverns = deferredCaverns;
            return this;
        }

        public GeneratorControllerBuilder burrows(List<BurrowGenerator> burrows) {
            this.burrows = burrows;
            return this;
        }

        public GeneratorControllerBuilder layers(List<LayerGenerator> layers) {
            this.layers = layers;
            return this;
        }

        public GeneratorControllerBuilder cavernTunnels(List<TunnelConnector<CavernGenerator>> cavernTunnels) {
            this.cavernTunnels = cavernTunnels;
            return this;
        }

        public GeneratorControllerBuilder burrowTunnels(List<TunnelConnector<BurrowGenerator>> burrowTunnels) {
            this.burrowTunnels = burrowTunnels;
            return this;
        }

        public GeneratorControllerBuilder globalClusters(ClusterGenerator globalClusters) {
            this.globalClusters = globalClusters;
            return this;
        }

        public GeneratorControllerBuilder layeredClusters(ClusterGenerator layeredClusters) {
            this.layeredClusters = layeredClusters;
            return this;
        }

        public GeneratorControllerBuilder stalactites(List<StalactiteGenerator> stalactites) {
            this.stalactites = stalactites;
            return this;
        }

        public GeneratorControllerBuilder pillars(List<PillarGenerator> pillars) {
            this.pillars = pillars;
            return this;
        }

        public GeneratorControllerBuilder structures(List<StructureGenerator> structures) {
            this.structures = structures;
            return this;
        }

        public GeneratorController build() {
            return new GeneratorController(this.tunnels, this.ravines, this.caverns, this.deferredCaverns, this.burrows, this.layers, this.cavernTunnels, this.burrowTunnels, this.globalClusters, this.layeredClusters, this.stalactites, this.pillars, this.structures);
        }

        public String toString() {
            return "GeneratorController.GeneratorControllerBuilder(tunnels=" + this.tunnels + ", ravines=" + this.ravines + ", caverns=" + this.caverns + ", deferredCaverns=" + this.deferredCaverns + ", burrows=" + this.burrows + ", layers=" + this.layers + ", cavernTunnels=" + this.cavernTunnels + ", burrowTunnels=" + this.burrowTunnels + ", globalClusters=" + this.globalClusters + ", layeredClusters=" + this.layeredClusters + ", stalactites=" + this.stalactites + ", pillars=" + this.pillars + ", structures=" + this.structures + ")";
        }
    }
}

