/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.util;

import com.personthecat.cavegenerator.util.CommonMethods;
import java.util.Optional;
import java.util.function.Consumer;

public class Result<E extends Throwable> {
    private static final Result<?> OK = new Result();
    private final E err;

    private Result() {
        this.err = null;
    }

    public static <E extends Throwable> Result<E> ok() {
        return OK;
    }

    private Result(E err) {
        if (err == null) {
            throw CommonMethods.runEx("Error: Attempted to construct an error with no value present.");
        }
        this.err = err;
    }

    public static <E extends Throwable> Result<E> of(E err) {
        return new Result<E>(err);
    }

    public static <E extends Throwable> Result<E> ofUnknown(E err) {
        return err == null ? Result.ok() : Result.of(err);
    }

    public boolean isErr() {
        return this.err != null;
    }

    public boolean isOk() {
        return this.err == null;
    }

    public Result<E> handleIfPresent(Consumer<E> func) {
        if (this.err != null) {
            func.accept(this.err);
        }
        return this;
    }

    public Result<E> andThen(Runnable func) {
        if (this.err == null) {
            func.run();
        }
        return this;
    }

    public void throwIfPresent() {
        if (this.err != null) {
            throw new RuntimeException((Throwable)this.err);
        }
    }

    public void expect(String message) {
        if (this.err != null) {
            throw new RuntimeException(message, (Throwable)this.err);
        }
    }

    public void expectF(String message, Object ... args) {
        if (this.err != null) {
            throw new RuntimeException(String.format(message, args), (Throwable)this.err);
        }
    }

    public Optional<String> getMessage() {
        return Optional.of(((Throwable)this.err).getMessage());
    }
}

