/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.util;

import java.io.File;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class CommonMethods {
    public static RuntimeException runEx(String x) {
        return new RuntimeException(x);
    }

    public static RuntimeException runEx(String x, Throwable t) {
        return new RuntimeException(x, t);
    }

    public static RuntimeException runExF(String x, Object ... args) {
        return new RuntimeException(CommonMethods.f(x, args));
    }

    public static String f(String s, Object ... args) {
        int begin = 0;
        int si = 0;
        int oi = 0;
        StringBuilder sb = new StringBuilder();
        while ((si = s.indexOf("{}", si)) >= 0) {
            sb.append(s, begin, si);
            sb.append(args[oi++]);
            begin = si += 2;
        }
        sb.append(s.substring(begin));
        return sb.toString();
    }

    public static <T> Optional<T> find(T[] values, Predicate<T> by) {
        for (T val : values) {
            if (!by.test(val)) continue;
            return CommonMethods.full(val);
        }
        return CommonMethods.empty();
    }

    public static <T> Optional<T> find(Collection<T> values, Predicate<T> by) {
        for (T val : values) {
            if (!by.test(val)) continue;
            return CommonMethods.full(val);
        }
        return CommonMethods.empty();
    }

    public static <T, U> List<U> map(List<T> list, Function<T, U> mapper) {
        return list.stream().map(mapper).collect(Collectors.toList());
    }

    public static <T> T[] toArray(List<T> list, Class<T> clazz) {
        return list.toArray((Object[])Array.newInstance(clazz, 0));
    }

    public static <K, V> Optional<V> safeGet(Map<K, V> map, K key) {
        return Optional.ofNullable(map.get(key));
    }

    public static String extension(File file) {
        return CommonMethods.extension(file.getName());
    }

    public static String extension(String filename) {
        String[] split = filename.split(Pattern.quote("."));
        return split.length == 1 ? "" : split[split.length - 1];
    }

    public static String noExtension(File file) {
        return CommonMethods.noExtension(file.getName());
    }

    public static String noExtension(String name) {
        return name.split(Pattern.quote("."))[0];
    }

    public static <T> Optional<T> empty() {
        return Optional.empty();
    }

    public static <T> Optional<T> full(T val) {
        return Optional.of(val);
    }

    public static <T> Optional<T> nullable(T val) {
        return Optional.ofNullable(val);
    }

    public static int numBetween(Random rand, int min, int max) {
        return min == max ? min : rand.nextInt(max - min + 1) + min;
    }

    public static float numBetween(Random rand, float min, float max) {
        return min == max ? min : rand.nextFloat() * (max - min) + min;
    }

    public static int[] sort(int[] array) {
        Arrays.sort(array);
        return array;
    }

    public static float[] sort(float[] array) {
        Arrays.sort(array);
        return array;
    }

    public static int invert(double value) {
        return value == 0.0 ? Integer.MAX_VALUE : (int)(1.0 / value);
    }

    public static Optional<Biome> getBiome(String biomeName) {
        return Optional.ofNullable(ForgeRegistries.BIOMES.getValue(new ResourceLocation(biomeName)));
    }

    public static Optional<Biome> getBiome(int biomeNumber) {
        return Optional.ofNullable(Biome.func_185357_a((int)biomeNumber));
    }

    public static Biome[] getBiomes(BiomeDictionary.Type biomeType) {
        return BiomeDictionary.getBiomes((BiomeDictionary.Type)biomeType).toArray(new Biome[0]);
    }

    public static BiomeDictionary.Type getBiomeType(String name) {
        return BiomeDictionary.Type.getType((String)name, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
    }

    public static Optional<IBlockState> getBlockState(String registryName) {
        if (registryName.equals("air") || registryName.equals("minecraft:air")) {
            return CommonMethods.full(Blocks.field_150350_a.func_176223_P());
        }
        String[] split = registryName.split(":");
        if (split.length <= 0 || split.length >= 4) {
            throw CommonMethods.runExF("Syntax error: could not determine block state from {}", registryName);
        }
        String end = split[split.length - 1];
        if (StringUtils.isNumeric((CharSequence)end)) {
            int meta = Integer.parseInt(end);
            String updated = registryName.replace(":" + end, "");
            return CommonMethods._getBlock(updated, meta);
        }
        return CommonMethods._getBlock(registryName, 0);
    }

    private static Optional<IBlockState> _getBlock(String registryName, int meta) {
        ResourceLocation location = new ResourceLocation(registryName);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(location);
        if (Blocks.field_150350_a.equals(block)) {
            return CommonMethods.empty();
        }
        if (block != null) {
            return CommonMethods.full(block.func_176203_a(meta));
        }
        return CommonMethods.empty();
    }
}

