/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.util;

import com.personthecat.cavegenerator.util.CommonMethods;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.regex.Pattern;

public class Calculator {
    private static final Pattern IS_EXP = Pattern.compile("[\\d.]*\\s*([-+/*()^]\\s*[\\d.]*\\s*)*");

    public static boolean isExpression(String exp) {
        return IS_EXP.matcher(exp).matches();
    }

    public static double evaluate(String exp) {
        try {
            return Calculator.evaluateInternal(exp);
        }
        catch (EmptyStackException e) {
            throw CommonMethods.runExF("Invalid expression: {}", exp);
        }
    }

    private static double evaluateInternal(String exp) {
        char[] tokens = exp.toCharArray();
        Stack<Double> values = new Stack<Double>();
        Stack<Character> ops = new Stack<Character>();
        boolean lastIsNumber = false;
        int sign = 1;
        for (int i = 0; i < tokens.length; ++i) {
            char token = tokens[i];
            if (token == ' ') continue;
            boolean number = Calculator.isNumeric(token);
            if (number) {
                StringBuilder buffer = new StringBuilder();
                while (i < tokens.length && Calculator.isNumeric(tokens[i])) {
                    char c = tokens[i++];
                    if (token == '.' && c == '.') {
                        throw new IllegalArgumentException("Invalid decimal");
                    }
                    buffer.append(c);
                }
                values.push((double)sign * Double.parseDouble(buffer.toString()));
                sign = 1;
                --i;
            } else if (token == '(') {
                if (lastIsNumber) {
                    ops.push(Character.valueOf('*'));
                }
                ops.push(Character.valueOf(token));
            } else if (token == ')') {
                while (((Character)ops.peek()).charValue() != '(') {
                    values.push(Calculator.applyOp(((Character)ops.pop()).charValue(), (Double)values.pop(), (Double)values.pop()));
                }
                ops.pop();
                number = true;
            } else if (Calculator.isOperator(token)) {
                if (!lastIsNumber) {
                    if (token == '-') {
                        sign = -sign;
                        continue;
                    }
                    if (token == '+') continue;
                }
                while (!ops.isEmpty() && Calculator.hasPrecedence(token, ((Character)ops.peek()).charValue())) {
                    values.push(Calculator.applyOp(((Character)ops.pop()).charValue(), (Double)values.pop(), (Double)values.pop()));
                }
                ops.push(Character.valueOf(token));
            }
            lastIsNumber = number;
        }
        while (!ops.isEmpty()) {
            values.push(Calculator.applyOp(((Character)ops.pop()).charValue(), (Double)values.pop(), (Double)values.pop()));
        }
        return (Double)values.pop();
    }

    private static boolean isNumeric(char c) {
        return c == '.' || c >= '0' && c <= '9';
    }

    private static boolean isOperator(char c) {
        return c == '+' || c == '-' || c == '*' || c == '/' || c == '^';
    }

    private static boolean hasPrecedence(char op1, char op2) {
        if (op2 == '(' || op2 == ')') {
            return false;
        }
        if (op1 == '^') {
            return false;
        }
        return op1 != '*' && op1 != '/' || op2 != '+' && op2 != '-';
    }

    private static double applyOp(char op, double b, double a) {
        switch (op) {
            case '+': {
                return a + b;
            }
            case '-': {
                return a - b;
            }
            case '^': {
                return Math.pow(a, b);
            }
            case '*': {
                return a * b;
            }
            case '/': {
                if (b == 0.0) {
                    throw new UnsupportedOperationException("Divide by zero");
                }
                return a / b;
            }
        }
        throw new UnsupportedOperationException("operator: " + op);
    }
}

