/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.model;

import com.personthecat.cavegenerator.util.CommonMethods;
import java.util.Random;

public class FloatRange {
    public final float min;
    public final float max;

    public FloatRange(float min, float max) {
        this.min = min;
        this.max = max;
    }

    public FloatRange(float a) {
        this(a, a);
    }

    public float rand(Random rand) {
        return CommonMethods.numBetween(rand, this.min, this.max);
    }

    public float diff() {
        return this.max - this.min;
    }

    public String toString() {
        return CommonMethods.f("Range[{}~{}]", Float.valueOf(this.min), Float.valueOf(this.max));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FloatRange)) {
            return false;
        }
        FloatRange other = (FloatRange)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.min, other.min) != 0) {
            return false;
        }
        return Float.compare(this.max, other.max) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof FloatRange;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.min);
        result = result * 59 + Float.floatToIntBits(this.max);
        return result;
    }
}

