/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.model;

import com.personthecat.cavegenerator.data.WallDecoratorSettings;
import com.personthecat.cavegenerator.noise.DummyGenerator;
import fastnoise.FastNoise;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class ConfiguredWallDecorator {
    public final WallDecoratorSettings cfg;
    public final FastNoise noise;

    public ConfiguredWallDecorator(WallDecoratorSettings cfg, World world) {
        this.cfg = cfg;
        this.noise = cfg.noise.map(n -> n.getGenerator(world)).orElse(new DummyGenerator(0.0f));
    }

    public boolean canGenerate(Random rand, IBlockState state, int x, int y, int z, int chunkX, int chunkZ) {
        return this.canGenerate(rand, x, y, z, chunkX, chunkZ) && this.matchesBlock(state);
    }

    public boolean canGenerate(Random rand, int x, int y, int z, int chunkX, int chunkZ) {
        return y >= this.cfg.height.min && y <= this.cfg.height.max && this.testNoise(x, y, z, chunkX, chunkZ);
    }

    private boolean testNoise(int x, int y, int z, int chunkX, int chunkZ) {
        int actualX = chunkX * 16 + x;
        int actualZ = chunkZ * 16 + z;
        return this.testNoise(actualX, y, actualZ);
    }

    private boolean testNoise(int x, int y, int z) {
        return this.noise.GetBoolean(x, y, z);
    }

    public boolean matchesBlock(IBlockState state) {
        for (IBlockState matcher : this.cfg.matchers) {
            if (!matcher.equals(state)) continue;
            return true;
        }
        return false;
    }

    public boolean decidePlace(IBlockState state, ChunkPrimer primer, int xO, int yO, int zO, int xD, int yD, int zD) {
        if (WallDecoratorSettings.Placement.OVERLAY.equals((Object)this.cfg.placement)) {
            primer.func_177855_a(xO, yO, zO, state);
            return true;
        }
        primer.func_177855_a(xD, yD, zD, state);
        return false;
    }
}

