/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.data;

import com.personthecat.cavegenerator.model.FloatRange;
import com.personthecat.cavegenerator.model.Range;
import com.personthecat.cavegenerator.noise.CachedNoiseGenerator;
import com.personthecat.cavegenerator.noise.DummyGenerator;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.HjsonMapper;
import com.personthecat.cavegenerator.util.XoRoShiRo;
import fastnoise.FastNoise;
import java.util.Optional;
import java.util.Random;
import net.minecraft.world.World;
import org.hjson.JsonObject;

public class NoiseSettings {
    public final Optional<Integer> seed;
    public final float frequency;
    public final FloatRange threshold;
    public final float stretch;
    public final float lacunarity;
    public final float gain;
    public final float perturbAmp;
    public final float perturbFreq;
    public final float jitterX;
    public final float jitterY;
    public final float jitterZ;
    public final int octaves;
    public final int offset;
    public final boolean perturb;
    public final boolean invert;
    public final boolean cache;
    public final boolean dummy;
    public final float dummyOutput;
    public final FastNoise.Interp interp;
    public final FastNoise.NoiseType type;
    public final FastNoise.FractalType fractal;
    public final FastNoise.CellularDistanceFunction distFunc;
    public final FastNoise.CellularReturnType returnType;
    public final FastNoise.NoiseType cellularLookup;

    public static NoiseSettings from(JsonObject json, NoiseSettings defaults) {
        return NoiseSettings.copyInto(json, defaults.toBuilder());
    }

    public static NoiseSettings from(JsonObject json) {
        return NoiseSettings.copyInto(json, NoiseSettings.builder());
    }

    private static NoiseSettings copyInto(JsonObject json, NoiseSettingsBuilder builder) {
        return new HjsonMapper(json).mapInt("seed", i -> builder.seed(CommonMethods.full(i))).mapFloat("frequency", builder::frequency).mapFloatRange("threshold", builder::threshold).mapFloat("stretch", builder::stretch).mapFloat("lacunarity", builder::lacunarity).mapFloat("gain", builder::gain).mapFloat("perturbAmp", builder::perturbAmp).mapFloat("perturbFreq", builder::perturbFreq).mapFloat("jitter", i -> builder.jitterX(i.floatValue()).jitterY(i.floatValue()).jitterZ(i.floatValue())).mapFloat("jitterX", builder::jitterX).mapFloat("jitterY", builder::jitterY).mapFloat("jitterZ", builder::jitterZ).mapInt("octaves", builder::octaves).mapInt("offset", builder::offset).mapBool("perturb", builder::perturb).mapBool("invert", builder::invert).mapBool("cache", builder::cache).mapBool("dummy", builder::dummy).mapFloat("dummyOutput", builder::dummyOutput).mapInterp("interp", builder::interp).mapNoiseType("type", builder::type).mapFractalType("fractal", builder::fractal).mapDistFunc("distFunc", builder::distFunc).mapReturnType("returnType", builder::returnType).mapNoiseType("cellularLookup", builder::cellularLookup).release(builder::build);
    }

    public FastNoise getGenerator(World world) {
        if (this.dummy) {
            return new DummyGenerator(this.dummyOutput);
        }
        FastNoise noise = new FastNoise(this.getSeed(world)).SetNoiseType(this.type).SetFrequency(this.frequency).SetFractalType(this.fractal).SetFractalOctaves(this.octaves).SetInvert(this.invert).SetFractalGain(this.gain).SetCellularReturnType(this.returnType).SetGradientPerturbAmp(this.perturbAmp).SetGradientPerturbFrequency(this.perturbFreq).SetGradientPerturb(this.perturb).SetFractalLacunarity(this.lacunarity).SetCellularNoiseLookup(this.cellularLookup).SetCellularDistanceFunction(this.distFunc).SetInterp(this.interp).SetCellularJitterX(this.jitterX).SetCellularJitterY(this.jitterY).SetCellularJitterZ(this.jitterZ).SetThreshold(this.threshold.min, this.threshold.max).SetStretch(this.stretch).SetOffset(this.offset);
        return this.cache ? new CachedNoiseGenerator(noise) : noise;
    }

    private int getSeed(World world) {
        return this.seed.map(num -> {
            XoRoShiRo rand = new XoRoShiRo(world.func_72905_C());
            FastNoise simple = new FastNoise(((Random)rand).nextInt());
            return Float.floatToIntBits(simple.GetNoise(num.intValue()));
        }).orElseGet(world.field_73012_v::nextInt);
    }

    private static Optional<Integer> $default$seed() {
        return CommonMethods.empty();
    }

    private static float $default$frequency() {
        return 1.0f;
    }

    private static FloatRange $default$threshold() {
        return Range.of(0.0f);
    }

    private static float $default$stretch() {
        return 1.0f;
    }

    private static float $default$lacunarity() {
        return 1.0f;
    }

    private static float $default$gain() {
        return 0.5f;
    }

    private static float $default$perturbAmp() {
        return 1.0f;
    }

    private static float $default$perturbFreq() {
        return 1.0f;
    }

    private static float $default$jitterX() {
        return 0.45f;
    }

    private static float $default$jitterY() {
        return 0.45f;
    }

    private static float $default$jitterZ() {
        return 0.45f;
    }

    private static int $default$octaves() {
        return 1;
    }

    private static int $default$offset() {
        return 0;
    }

    private static boolean $default$perturb() {
        return false;
    }

    private static boolean $default$invert() {
        return false;
    }

    private static boolean $default$cache() {
        return false;
    }

    private static boolean $default$dummy() {
        return false;
    }

    private static float $default$dummyOutput() {
        return 1.0f;
    }

    private static FastNoise.Interp $default$interp() {
        return FastNoise.Interp.Hermite;
    }

    private static FastNoise.NoiseType $default$type() {
        return FastNoise.NoiseType.SimplexFractal;
    }

    private static FastNoise.FractalType $default$fractal() {
        return FastNoise.FractalType.FBM;
    }

    private static FastNoise.CellularDistanceFunction $default$distFunc() {
        return FastNoise.CellularDistanceFunction.Euclidean;
    }

    private static FastNoise.CellularReturnType $default$returnType() {
        return FastNoise.CellularReturnType.Distance2;
    }

    private static FastNoise.NoiseType $default$cellularLookup() {
        return FastNoise.NoiseType.Simplex;
    }

    NoiseSettings(Optional<Integer> seed, float frequency, FloatRange threshold, float stretch, float lacunarity, float gain, float perturbAmp, float perturbFreq, float jitterX, float jitterY, float jitterZ, int octaves, int offset, boolean perturb, boolean invert, boolean cache, boolean dummy, float dummyOutput, FastNoise.Interp interp, FastNoise.NoiseType type, FastNoise.FractalType fractal, FastNoise.CellularDistanceFunction distFunc, FastNoise.CellularReturnType returnType, FastNoise.NoiseType cellularLookup) {
        this.seed = seed;
        this.frequency = frequency;
        this.threshold = threshold;
        this.stretch = stretch;
        this.lacunarity = lacunarity;
        this.gain = gain;
        this.perturbAmp = perturbAmp;
        this.perturbFreq = perturbFreq;
        this.jitterX = jitterX;
        this.jitterY = jitterY;
        this.jitterZ = jitterZ;
        this.octaves = octaves;
        this.offset = offset;
        this.perturb = perturb;
        this.invert = invert;
        this.cache = cache;
        this.dummy = dummy;
        this.dummyOutput = dummyOutput;
        this.interp = interp;
        this.type = type;
        this.fractal = fractal;
        this.distFunc = distFunc;
        this.returnType = returnType;
        this.cellularLookup = cellularLookup;
    }

    public static NoiseSettingsBuilder builder() {
        return new NoiseSettingsBuilder();
    }

    public NoiseSettingsBuilder toBuilder() {
        return new NoiseSettingsBuilder().seed(this.seed).frequency(this.frequency).threshold(this.threshold).stretch(this.stretch).lacunarity(this.lacunarity).gain(this.gain).perturbAmp(this.perturbAmp).perturbFreq(this.perturbFreq).jitterX(this.jitterX).jitterY(this.jitterY).jitterZ(this.jitterZ).octaves(this.octaves).offset(this.offset).perturb(this.perturb).invert(this.invert).cache(this.cache).dummy(this.dummy).dummyOutput(this.dummyOutput).interp(this.interp).type(this.type).fractal(this.fractal).distFunc(this.distFunc).returnType(this.returnType).cellularLookup(this.cellularLookup);
    }

    public static final class Fields {
        public static final String seed = "seed";
        public static final String frequency = "frequency";
        public static final String threshold = "threshold";
        public static final String stretch = "stretch";
        public static final String lacunarity = "lacunarity";
        public static final String gain = "gain";
        public static final String perturbAmp = "perturbAmp";
        public static final String perturbFreq = "perturbFreq";
        public static final String jitterX = "jitterX";
        public static final String jitterY = "jitterY";
        public static final String jitterZ = "jitterZ";
        public static final String octaves = "octaves";
        public static final String offset = "offset";
        public static final String perturb = "perturb";
        public static final String invert = "invert";
        public static final String cache = "cache";
        public static final String dummy = "dummy";
        public static final String dummyOutput = "dummyOutput";
        public static final String interp = "interp";
        public static final String type = "type";
        public static final String fractal = "fractal";
        public static final String distFunc = "distFunc";
        public static final String returnType = "returnType";
        public static final String cellularLookup = "cellularLookup";

        private Fields() {
        }
    }

    public static class NoiseSettingsBuilder {
        private boolean seed$set;
        private Optional<Integer> seed$value;
        private boolean frequency$set;
        private float frequency$value;
        private boolean threshold$set;
        private FloatRange threshold$value;
        private boolean stretch$set;
        private float stretch$value;
        private boolean lacunarity$set;
        private float lacunarity$value;
        private boolean gain$set;
        private float gain$value;
        private boolean perturbAmp$set;
        private float perturbAmp$value;
        private boolean perturbFreq$set;
        private float perturbFreq$value;
        private boolean jitterX$set;
        private float jitterX$value;
        private boolean jitterY$set;
        private float jitterY$value;
        private boolean jitterZ$set;
        private float jitterZ$value;
        private boolean octaves$set;
        private int octaves$value;
        private boolean offset$set;
        private int offset$value;
        private boolean perturb$set;
        private boolean perturb$value;
        private boolean invert$set;
        private boolean invert$value;
        private boolean cache$set;
        private boolean cache$value;
        private boolean dummy$set;
        private boolean dummy$value;
        private boolean dummyOutput$set;
        private float dummyOutput$value;
        private boolean interp$set;
        private FastNoise.Interp interp$value;
        private boolean type$set;
        private FastNoise.NoiseType type$value;
        private boolean fractal$set;
        private FastNoise.FractalType fractal$value;
        private boolean distFunc$set;
        private FastNoise.CellularDistanceFunction distFunc$value;
        private boolean returnType$set;
        private FastNoise.CellularReturnType returnType$value;
        private boolean cellularLookup$set;
        private FastNoise.NoiseType cellularLookup$value;

        NoiseSettingsBuilder() {
        }

        public NoiseSettingsBuilder seed(Optional<Integer> seed) {
            this.seed$value = seed;
            this.seed$set = true;
            return this;
        }

        public NoiseSettingsBuilder frequency(float frequency) {
            this.frequency$value = frequency;
            this.frequency$set = true;
            return this;
        }

        public NoiseSettingsBuilder threshold(FloatRange threshold) {
            this.threshold$value = threshold;
            this.threshold$set = true;
            return this;
        }

        public NoiseSettingsBuilder stretch(float stretch) {
            this.stretch$value = stretch;
            this.stretch$set = true;
            return this;
        }

        public NoiseSettingsBuilder lacunarity(float lacunarity) {
            this.lacunarity$value = lacunarity;
            this.lacunarity$set = true;
            return this;
        }

        public NoiseSettingsBuilder gain(float gain) {
            this.gain$value = gain;
            this.gain$set = true;
            return this;
        }

        public NoiseSettingsBuilder perturbAmp(float perturbAmp) {
            this.perturbAmp$value = perturbAmp;
            this.perturbAmp$set = true;
            return this;
        }

        public NoiseSettingsBuilder perturbFreq(float perturbFreq) {
            this.perturbFreq$value = perturbFreq;
            this.perturbFreq$set = true;
            return this;
        }

        public NoiseSettingsBuilder jitterX(float jitterX) {
            this.jitterX$value = jitterX;
            this.jitterX$set = true;
            return this;
        }

        public NoiseSettingsBuilder jitterY(float jitterY) {
            this.jitterY$value = jitterY;
            this.jitterY$set = true;
            return this;
        }

        public NoiseSettingsBuilder jitterZ(float jitterZ) {
            this.jitterZ$value = jitterZ;
            this.jitterZ$set = true;
            return this;
        }

        public NoiseSettingsBuilder octaves(int octaves) {
            this.octaves$value = octaves;
            this.octaves$set = true;
            return this;
        }

        public NoiseSettingsBuilder offset(int offset) {
            this.offset$value = offset;
            this.offset$set = true;
            return this;
        }

        public NoiseSettingsBuilder perturb(boolean perturb) {
            this.perturb$value = perturb;
            this.perturb$set = true;
            return this;
        }

        public NoiseSettingsBuilder invert(boolean invert) {
            this.invert$value = invert;
            this.invert$set = true;
            return this;
        }

        public NoiseSettingsBuilder cache(boolean cache) {
            this.cache$value = cache;
            this.cache$set = true;
            return this;
        }

        public NoiseSettingsBuilder dummy(boolean dummy) {
            this.dummy$value = dummy;
            this.dummy$set = true;
            return this;
        }

        public NoiseSettingsBuilder dummyOutput(float dummyOutput) {
            this.dummyOutput$value = dummyOutput;
            this.dummyOutput$set = true;
            return this;
        }

        public NoiseSettingsBuilder interp(FastNoise.Interp interp) {
            this.interp$value = interp;
            this.interp$set = true;
            return this;
        }

        public NoiseSettingsBuilder type(FastNoise.NoiseType type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        public NoiseSettingsBuilder fractal(FastNoise.FractalType fractal) {
            this.fractal$value = fractal;
            this.fractal$set = true;
            return this;
        }

        public NoiseSettingsBuilder distFunc(FastNoise.CellularDistanceFunction distFunc) {
            this.distFunc$value = distFunc;
            this.distFunc$set = true;
            return this;
        }

        public NoiseSettingsBuilder returnType(FastNoise.CellularReturnType returnType) {
            this.returnType$value = returnType;
            this.returnType$set = true;
            return this;
        }

        public NoiseSettingsBuilder cellularLookup(FastNoise.NoiseType cellularLookup) {
            this.cellularLookup$value = cellularLookup;
            this.cellularLookup$set = true;
            return this;
        }

        public NoiseSettings build() {
            Optional seed$value = this.seed$value;
            if (!this.seed$set) {
                seed$value = NoiseSettings.$default$seed();
            }
            float frequency$value = this.frequency$value;
            if (!this.frequency$set) {
                frequency$value = NoiseSettings.$default$frequency();
            }
            FloatRange threshold$value = this.threshold$value;
            if (!this.threshold$set) {
                threshold$value = NoiseSettings.$default$threshold();
            }
            float stretch$value = this.stretch$value;
            if (!this.stretch$set) {
                stretch$value = NoiseSettings.$default$stretch();
            }
            float lacunarity$value = this.lacunarity$value;
            if (!this.lacunarity$set) {
                lacunarity$value = NoiseSettings.$default$lacunarity();
            }
            float gain$value = this.gain$value;
            if (!this.gain$set) {
                gain$value = NoiseSettings.$default$gain();
            }
            float perturbAmp$value = this.perturbAmp$value;
            if (!this.perturbAmp$set) {
                perturbAmp$value = NoiseSettings.$default$perturbAmp();
            }
            float perturbFreq$value = this.perturbFreq$value;
            if (!this.perturbFreq$set) {
                perturbFreq$value = NoiseSettings.$default$perturbFreq();
            }
            float jitterX$value = this.jitterX$value;
            if (!this.jitterX$set) {
                jitterX$value = NoiseSettings.$default$jitterX();
            }
            float jitterY$value = this.jitterY$value;
            if (!this.jitterY$set) {
                jitterY$value = NoiseSettings.$default$jitterY();
            }
            float jitterZ$value = this.jitterZ$value;
            if (!this.jitterZ$set) {
                jitterZ$value = NoiseSettings.$default$jitterZ();
            }
            int octaves$value = this.octaves$value;
            if (!this.octaves$set) {
                octaves$value = NoiseSettings.$default$octaves();
            }
            int offset$value = this.offset$value;
            if (!this.offset$set) {
                offset$value = NoiseSettings.$default$offset();
            }
            boolean perturb$value = this.perturb$value;
            if (!this.perturb$set) {
                perturb$value = NoiseSettings.$default$perturb();
            }
            boolean invert$value = this.invert$value;
            if (!this.invert$set) {
                invert$value = NoiseSettings.$default$invert();
            }
            boolean cache$value = this.cache$value;
            if (!this.cache$set) {
                cache$value = NoiseSettings.$default$cache();
            }
            boolean dummy$value = this.dummy$value;
            if (!this.dummy$set) {
                dummy$value = NoiseSettings.$default$dummy();
            }
            float dummyOutput$value = this.dummyOutput$value;
            if (!this.dummyOutput$set) {
                dummyOutput$value = NoiseSettings.$default$dummyOutput();
            }
            FastNoise.Interp interp$value = this.interp$value;
            if (!this.interp$set) {
                interp$value = NoiseSettings.$default$interp();
            }
            FastNoise.NoiseType type$value = this.type$value;
            if (!this.type$set) {
                type$value = NoiseSettings.$default$type();
            }
            FastNoise.FractalType fractal$value = this.fractal$value;
            if (!this.fractal$set) {
                fractal$value = NoiseSettings.$default$fractal();
            }
            FastNoise.CellularDistanceFunction distFunc$value = this.distFunc$value;
            if (!this.distFunc$set) {
                distFunc$value = NoiseSettings.$default$distFunc();
            }
            FastNoise.CellularReturnType returnType$value = this.returnType$value;
            if (!this.returnType$set) {
                returnType$value = NoiseSettings.$default$returnType();
            }
            FastNoise.NoiseType cellularLookup$value = this.cellularLookup$value;
            if (!this.cellularLookup$set) {
                cellularLookup$value = NoiseSettings.$default$cellularLookup();
            }
            return new NoiseSettings(seed$value, frequency$value, threshold$value, stretch$value, lacunarity$value, gain$value, perturbAmp$value, perturbFreq$value, jitterX$value, jitterY$value, jitterZ$value, octaves$value, offset$value, perturb$value, invert$value, cache$value, dummy$value, dummyOutput$value, interp$value, type$value, fractal$value, distFunc$value, returnType$value, cellularLookup$value);
        }

        public String toString() {
            return "NoiseSettings.NoiseSettingsBuilder(seed$value=" + this.seed$value + ", frequency$value=" + this.frequency$value + ", threshold$value=" + this.threshold$value + ", stretch$value=" + this.stretch$value + ", lacunarity$value=" + this.lacunarity$value + ", gain$value=" + this.gain$value + ", perturbAmp$value=" + this.perturbAmp$value + ", perturbFreq$value=" + this.perturbFreq$value + ", jitterX$value=" + this.jitterX$value + ", jitterY$value=" + this.jitterY$value + ", jitterZ$value=" + this.jitterZ$value + ", octaves$value=" + this.octaves$value + ", offset$value=" + this.offset$value + ", perturb$value=" + this.perturb$value + ", invert$value=" + this.invert$value + ", cache$value=" + this.cache$value + ", dummy$value=" + this.dummy$value + ", dummyOutput$value=" + this.dummyOutput$value + ", interp$value=" + (Object)((Object)this.interp$value) + ", type$value=" + (Object)((Object)this.type$value) + ", fractal$value=" + (Object)((Object)this.fractal$value) + ", distFunc$value=" + (Object)((Object)this.distFunc$value) + ", returnType$value=" + (Object)((Object)this.returnType$value) + ", cellularLookup$value=" + (Object)((Object)this.cellularLookup$value) + ")";
        }
    }
}

