/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.data;

import com.personthecat.cavegenerator.data.ConditionSettings;
import com.personthecat.cavegenerator.data.NoiseSettings;
import com.personthecat.cavegenerator.data.OverrideSettings;
import com.personthecat.cavegenerator.model.Range;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.HjsonMapper;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import org.apache.commons.lang3.tuple.Pair;
import org.hjson.JsonObject;

public class ClusterSettings {
    private static final String FEATURE_NAME = "clusters";
    private static final ConditionSettings DEFAULT_CONDITIONS = ConditionSettings.builder().build();
    public final ConditionSettings conditions;
    public final List<Pair<IBlockState, Integer>> states;
    public final double selectionThreshold;
    public final double chance;
    public final double integrity;
    public final Range radiusX;
    public final Range radiusY;
    public final Range radiusZ;
    public final Range centerHeight;
    public final List<IBlockState> matchers;
    public final boolean spawnInAir;
    public static final NoiseSettings DEFAULT_NOISE = NoiseSettings.builder().frequency(0.0143f).threshold(Range.of(-0.6f)).stretch(0.5f).octaves(1).build();

    public static ClusterSettings from(JsonObject json, OverrideSettings overrides) {
        ConditionSettings conditions = overrides.apply(DEFAULT_CONDITIONS.toBuilder()).build();
        return ClusterSettings.copyInto(json, ClusterSettings.builder().conditions(conditions));
    }

    public static ClusterSettings from(JsonObject json) {
        return ClusterSettings.copyInto(json, ClusterSettings.builder());
    }

    private static ClusterSettings copyInto(JsonObject json, ClusterSettingsBuilder builder) {
        ClusterSettings original = builder.build();
        return new HjsonMapper(json).mapRequiredStateList("states", FEATURE_NAME, l -> ClusterSettings.copyStates(builder, l)).mapSelf(o -> builder.conditions(ConditionSettings.from(o, original.conditions))).mapFloat("chance", f -> ClusterSettings.copyChance(builder, f.floatValue())).mapFloat("integrity", builder::integrity).mapRange("radius", r -> ClusterSettings.copyRadius(builder, r)).mapRange("radiusX", builder::radiusX).mapRange("radiusY", builder::radiusY).mapRange("radiusZ", builder::radiusZ).mapRange("centerHeight", builder::centerHeight).mapStateList("matchers", builder::matchers).mapBool("spawnInAir", builder::spawnInAir).mapInt("seed", i -> ClusterSettings.copySeed(builder, i)).release(builder::build);
    }

    private static void copyStates(ClusterSettingsBuilder builder, List<IBlockState> states) {
        builder.states(states.stream().map(s -> Pair.of((Object)s, (Object)Block.func_176210_f((IBlockState)s))).collect(Collectors.toList()));
    }

    private static void copyChance(ClusterSettingsBuilder builder, float chance) {
        builder.chance(chance).selectionThreshold((1.0f - chance) * 92.0f);
    }

    private static void copyRadius(ClusterSettingsBuilder builder, Range radius) {
        builder.radiusX(radius).radiusY(radius).radiusZ(radius);
    }

    private static void copySeed(ClusterSettingsBuilder builder, int seed) {
        List states = Objects.requireNonNull(builder.states, "Out of order");
        builder.states(CommonMethods.map(states, p -> Pair.of((Object)p.getLeft(), (Object)seed)));
    }

    public boolean canSpawn(IBlockState state) {
        if (state.func_177230_c().equals(Blocks.field_150350_a)) {
            return this.spawnInAir;
        }
        if (this.matchers.isEmpty()) {
            return !Blocks.field_150357_h.equals(state.func_177230_c()) && Material.field_151576_e.equals(state.func_185904_a());
        }
        return this.matchers.contains(state);
    }

    private static ConditionSettings $default$conditions() {
        return DEFAULT_CONDITIONS;
    }

    private static double $default$selectionThreshold() {
        return 78.2;
    }

    private static double $default$chance() {
        return 0.15;
    }

    private static double $default$integrity() {
        return 1.0;
    }

    private static Range $default$radiusX() {
        return Range.of(13, 19);
    }

    private static Range $default$radiusY() {
        return Range.of(9, 15);
    }

    private static Range $default$radiusZ() {
        return Range.of(13, 19);
    }

    private static Range $default$centerHeight() {
        return Range.of(24, 40);
    }

    private static List<IBlockState> $default$matchers() {
        return Collections.emptyList();
    }

    private static boolean $default$spawnInAir() {
        return false;
    }

    ClusterSettings(ConditionSettings conditions, List<Pair<IBlockState, Integer>> states, double selectionThreshold, double chance, double integrity, Range radiusX, Range radiusY, Range radiusZ, Range centerHeight, List<IBlockState> matchers, boolean spawnInAir) {
        this.conditions = conditions;
        this.states = states;
        this.selectionThreshold = selectionThreshold;
        this.chance = chance;
        this.integrity = integrity;
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.radiusZ = radiusZ;
        this.centerHeight = centerHeight;
        this.matchers = matchers;
        this.spawnInAir = spawnInAir;
    }

    public static ClusterSettingsBuilder builder() {
        return new ClusterSettingsBuilder();
    }

    public static final class Fields {
        public static final String conditions = "conditions";
        public static final String states = "states";
        public static final String selectionThreshold = "selectionThreshold";
        public static final String chance = "chance";
        public static final String integrity = "integrity";
        public static final String radiusX = "radiusX";
        public static final String radiusY = "radiusY";
        public static final String radiusZ = "radiusZ";
        public static final String centerHeight = "centerHeight";
        public static final String matchers = "matchers";
        public static final String spawnInAir = "spawnInAir";

        private Fields() {
        }
    }

    public static class ClusterSettingsBuilder {
        private boolean conditions$set;
        private ConditionSettings conditions$value;
        private List<Pair<IBlockState, Integer>> states;
        private boolean selectionThreshold$set;
        private double selectionThreshold$value;
        private boolean chance$set;
        private double chance$value;
        private boolean integrity$set;
        private double integrity$value;
        private boolean radiusX$set;
        private Range radiusX$value;
        private boolean radiusY$set;
        private Range radiusY$value;
        private boolean radiusZ$set;
        private Range radiusZ$value;
        private boolean centerHeight$set;
        private Range centerHeight$value;
        private boolean matchers$set;
        private List<IBlockState> matchers$value;
        private boolean spawnInAir$set;
        private boolean spawnInAir$value;

        ClusterSettingsBuilder() {
        }

        public ClusterSettingsBuilder conditions(ConditionSettings conditions) {
            this.conditions$value = conditions;
            this.conditions$set = true;
            return this;
        }

        public ClusterSettingsBuilder states(List<Pair<IBlockState, Integer>> states) {
            this.states = states;
            return this;
        }

        public ClusterSettingsBuilder selectionThreshold(double selectionThreshold) {
            this.selectionThreshold$value = selectionThreshold;
            this.selectionThreshold$set = true;
            return this;
        }

        public ClusterSettingsBuilder chance(double chance) {
            this.chance$value = chance;
            this.chance$set = true;
            return this;
        }

        public ClusterSettingsBuilder integrity(double integrity) {
            this.integrity$value = integrity;
            this.integrity$set = true;
            return this;
        }

        public ClusterSettingsBuilder radiusX(Range radiusX) {
            this.radiusX$value = radiusX;
            this.radiusX$set = true;
            return this;
        }

        public ClusterSettingsBuilder radiusY(Range radiusY) {
            this.radiusY$value = radiusY;
            this.radiusY$set = true;
            return this;
        }

        public ClusterSettingsBuilder radiusZ(Range radiusZ) {
            this.radiusZ$value = radiusZ;
            this.radiusZ$set = true;
            return this;
        }

        public ClusterSettingsBuilder centerHeight(Range centerHeight) {
            this.centerHeight$value = centerHeight;
            this.centerHeight$set = true;
            return this;
        }

        public ClusterSettingsBuilder matchers(List<IBlockState> matchers) {
            this.matchers$value = matchers;
            this.matchers$set = true;
            return this;
        }

        public ClusterSettingsBuilder spawnInAir(boolean spawnInAir) {
            this.spawnInAir$value = spawnInAir;
            this.spawnInAir$set = true;
            return this;
        }

        public ClusterSettings build() {
            ConditionSettings conditions$value = this.conditions$value;
            if (!this.conditions$set) {
                conditions$value = ClusterSettings.$default$conditions();
            }
            double selectionThreshold$value = this.selectionThreshold$value;
            if (!this.selectionThreshold$set) {
                selectionThreshold$value = ClusterSettings.$default$selectionThreshold();
            }
            double chance$value = this.chance$value;
            if (!this.chance$set) {
                chance$value = ClusterSettings.$default$chance();
            }
            double integrity$value = this.integrity$value;
            if (!this.integrity$set) {
                integrity$value = ClusterSettings.$default$integrity();
            }
            Range radiusX$value = this.radiusX$value;
            if (!this.radiusX$set) {
                radiusX$value = ClusterSettings.$default$radiusX();
            }
            Range radiusY$value = this.radiusY$value;
            if (!this.radiusY$set) {
                radiusY$value = ClusterSettings.$default$radiusY();
            }
            Range radiusZ$value = this.radiusZ$value;
            if (!this.radiusZ$set) {
                radiusZ$value = ClusterSettings.$default$radiusZ();
            }
            Range centerHeight$value = this.centerHeight$value;
            if (!this.centerHeight$set) {
                centerHeight$value = ClusterSettings.$default$centerHeight();
            }
            List matchers$value = this.matchers$value;
            if (!this.matchers$set) {
                matchers$value = ClusterSettings.$default$matchers();
            }
            boolean spawnInAir$value = this.spawnInAir$value;
            if (!this.spawnInAir$set) {
                spawnInAir$value = ClusterSettings.$default$spawnInAir();
            }
            return new ClusterSettings(conditions$value, this.states, selectionThreshold$value, chance$value, integrity$value, radiusX$value, radiusY$value, radiusZ$value, centerHeight$value, matchers$value, spawnInAir$value);
        }

        public String toString() {
            return "ClusterSettings.ClusterSettingsBuilder(conditions$value=" + this.conditions$value + ", states=" + this.states + ", selectionThreshold$value=" + this.selectionThreshold$value + ", chance$value=" + this.chance$value + ", integrity$value=" + this.integrity$value + ", radiusX$value=" + this.radiusX$value + ", radiusY$value=" + this.radiusY$value + ", radiusZ$value=" + this.radiusZ$value + ", centerHeight$value=" + this.centerHeight$value + ", matchers$value=" + this.matchers$value + ", spawnInAir$value=" + this.spawnInAir$value + ")";
        }
    }
}

