/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.config;

import com.personthecat.cavegenerator.CaveInit;
import com.personthecat.cavegenerator.config.PresetReader;
import com.personthecat.cavegenerator.io.SafeFileIO;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.HjsonTools;
import com.personthecat.cavegenerator.util.PathComponent;
import java.io.File;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.CharUtils;
import org.hjson.JsonObject;
import org.hjson.JsonValue;

public class PresetCombiner {
    public static void combine(String from, String to) {
        List<PathComponent> components;
        int endOfName = from.indexOf(46);
        File fileFrom = PresetCombiner.getRequiredPreset(from.substring(0, endOfName));
        File fileTo = PresetCombiner.getRequiredPreset(to);
        JsonObject objFrom = PresetCombiner.getRequiredJson(fileFrom);
        JsonObject objTo = PresetCombiner.getRequiredJson(fileTo);
        try {
            components = PresetCombiner.processPath(from.substring(endOfName + 1));
        }
        catch (IOException e) {
            throw CommonMethods.runEx(e.getMessage());
        }
        SafeFileIO.backup(fileTo);
        PresetCombiner.run(components, objFrom, objTo, fileTo);
    }

    private static File getRequiredPreset(String path) {
        return CaveInit.locatePreset(path).orElseThrow(() -> CommonMethods.runExF("Unable to locate a preset named \"{}\"", path));
    }

    private static JsonObject getRequiredJson(File file) {
        return PresetReader.getPresetJson(file).orElseThrow(() -> CommonMethods.runExF("{} does not contain a valid json or hjson object.", file.getName()));
    }

    private static void run(List<PathComponent> components, JsonObject from, JsonObject to, File fileTo) {
        JsonValue fromValue = HjsonTools.getLastContainer(from, components);
        if (fromValue.isObject()) {
            String key = components.get((int)(components.size() - 1)).key.orElseThrow(() -> CommonMethods.runEx("Expected an object at end of path."));
            fromValue = fromValue.asObject().get(key);
        } else if (fromValue.isArray()) {
            int index = components.get((int)(components.size() - 1)).index.orElseThrow(() -> CommonMethods.runEx("Expected an array at end of path."));
            fromValue = fromValue.asArray().get(index);
        }
        HjsonTools.setValueFromPath(to, components, fromValue);
        HjsonTools.writeJson(to, fileTo).throwIfPresent();
    }

    private static List<PathComponent> processPath(String path) throws IOException {
        PushbackReader reader = new PushbackReader(new StringReader(path));
        ArrayList<PathComponent> components = new ArrayList<PathComponent>();
        StringBuilder currentPath = new StringBuilder();
        String first = PresetCombiner.readString(reader, currentPath);
        components.add(PathComponent.key(first));
        currentPath.append(first);
        while (reader.ready()) {
            int current = reader.read();
            currentPath.append((char)current);
            if (current == -1 || current == 65535) break;
            if (current == 46) {
                String key = PresetCombiner.readString(reader, currentPath);
                components.add(PathComponent.key(key));
                currentPath.append(key);
                continue;
            }
            if (current == 91) {
                int index = PresetCombiner.readInt(reader, currentPath);
                components.add(PathComponent.index(index));
                currentPath.append(index);
                PresetCombiner.expect(reader, path, ']');
                currentPath.append(']');
                continue;
            }
            throw CommonMethods.runExF("Invalid character ({}) in path: {} <- Here", Character.valueOf((char)current), currentPath);
        }
        reader.close();
        return components;
    }

    private static String readString(PushbackReader reader, CharSequence path) throws IOException {
        int current;
        StringBuilder sb = new StringBuilder();
        while (CharUtils.isAsciiAlphanumeric((char)((char)(current = reader.read())))) {
            sb.append((char)current);
        }
        if (sb.length() == 0) {
            throw CommonMethods.runExF("Expected key in path: {} <- Here", path);
        }
        reader.unread(current);
        return sb.toString();
    }

    private static int readInt(PushbackReader reader, CharSequence path) throws IOException {
        int current;
        StringBuilder sb = new StringBuilder();
        while (CharUtils.isAsciiNumeric((char)((char)(current = reader.read())))) {
            sb.append((char)current);
        }
        if (sb.length() == 0) {
            throw CommonMethods.runExF("Expected index in path: {} <- Here", path);
        }
        reader.unread(current);
        int parsed = Integer.parseInt(sb.toString());
        if (parsed <= 0) {
            throw CommonMethods.runExF("Invalid index ({}) in path: {} <- Here", parsed, path);
        }
        return parsed;
    }

    private static void expect(PushbackReader reader, CharSequence path, char ch) throws IOException {
        if (reader.read() != ch) {
            throw CommonMethods.runExF("Expected {} in path: {} <- Here", Character.valueOf(ch), path);
        }
    }
}

