/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator;

import com.personthecat.cavegenerator.config.CavePreset;
import com.personthecat.cavegenerator.config.ConfigFile;
import com.personthecat.cavegenerator.config.PresetReader;
import com.personthecat.cavegenerator.io.SafeFileIO;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.HjsonTools;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraftforge.fml.common.Loader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CaveInit {
    private static final Logger log = LogManager.getLogger(CaveInit.class);
    private static final String BACKUPS = "cavegenerator/backup";
    private static final String EXAMPLES = "cavegenerator/examples";
    private static final String PRESETS = "cavegenerator/presets";
    private static final String IMPORTS = "cavegenerator/imports";
    private static final String GENERATED = "cavegenerator/generated";
    private static final String NO_ACCESS = "Currently unable to access preset directory.";
    private static final String CANT_CREATE = "Unable to create directory";
    private static final List<String> EXTENSIONS = Arrays.asList("hjson", "json", "cave");
    private static final File CONFIG_DIR = Loader.instance().getConfigDir();
    public static final File CG_DIR = new File(CONFIG_DIR, "cavegenerator");
    public static final File BACKUP_DIR = new File(CONFIG_DIR, "cavegenerator/backup");
    public static final File EXAMPLE_DIR = new File(CONFIG_DIR, "cavegenerator/examples");
    public static final File PRESET_DIR = new File(CONFIG_DIR, "cavegenerator/presets");
    public static final File IMPORT_DIR = new File(CONFIG_DIR, "cavegenerator/imports");
    public static final File GENERATED_DIR = new File(CONFIG_DIR, "cavegenerator/generated");

    public static void initPresets(Map<String, CavePreset> presets) {
        SafeFileIO.ensureDirExists(PRESET_DIR).expect(CANT_CREATE);
        SafeFileIO.ensureDirExists(IMPORT_DIR).expect(CANT_CREATE);
        presets.clear();
        presets.putAll(PresetReader.getPresets(PRESET_DIR, IMPORT_DIR));
        if (ConfigFile.autoGenerate) {
            SafeFileIO.ensureDirExists(GENERATED_DIR).expect(CANT_CREATE);
            presets.forEach((name, preset) -> {
                File file = new File(GENERATED_DIR, name + ".cave");
                HjsonTools.writeJson(preset.raw, file).throwIfPresent();
            });
        }
        CaveInit.printLoadedPresets(presets);
    }

    public static Optional<File> locatePreset(String preset) {
        return CaveInit.locatePreset(PRESET_DIR, preset);
    }

    public static Optional<File> locatePreset(File directory, String preset) {
        File presetFile = new File(directory, preset);
        if (SafeFileIO.fileExists(presetFile, "Error checking file: " + presetFile)) {
            return CommonMethods.full(presetFile);
        }
        for (String ext : EXTENSIONS) {
            Optional<File> found = CaveInit.tryExtension(directory, preset, ext);
            if (!found.isPresent()) continue;
            return found;
        }
        return CommonMethods.empty();
    }

    private static Optional<File> tryExtension(File directory, String preset, String extension) {
        File presetFile = new File(directory, preset + "." + extension);
        if (SafeFileIO.fileExists(presetFile, NO_ACCESS)) {
            return CommonMethods.full(presetFile);
        }
        return CommonMethods.empty();
    }

    public static boolean validExtension(File file) {
        return EXTENSIONS.contains(CommonMethods.extension(file));
    }

    private static void printLoadedPresets(Map<String, CavePreset> presets) {
        for (Map.Entry<String, CavePreset> entry : presets.entrySet()) {
            String enabled = entry.getValue().enabled ? "enabled" : "disabled";
            log.info("{} is {}.", (Object)entry.getKey(), (Object)enabled);
        }
    }
}

