/*
 * Decompiled with CFR 0.152.
 */
package com.mcf.davidee.paintinggui.packet;

import com.mcf.davidee.paintinggui.mod.PaintingSelection;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CPacketPainting
implements IMessage {
    public int id;
    public String[] art;

    public CPacketPainting() {
    }

    public CPacketPainting(int toSend, String[] data) {
        this.id = toSend;
        this.art = data;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.art.length);
        for (int i = 0; i < this.art.length; ++i) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.art[i]);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        String[] s = new String[buf.readInt()];
        for (int i = 0; i < s.length; ++i) {
            s[i] = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
        this.art = s;
    }

    public static class CPaintingMessageHandler
    implements IMessageHandler<CPacketPainting, IMessage> {
        public IMessage onMessage(CPacketPainting message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                if (message.id == -1) {
                    PaintingSelection.proxy.processRayTracing();
                } else if (message.art.length == 1) {
                    EntityPainting.EnumArt enumArt = this.getEnumArt(message.art[0]);
                    Entity e = PaintingSelection.proxy.getClientPlayer().field_70170_p.func_73045_a(message.id);
                    if (e instanceof EntityPainting) {
                        this.setPaintingArt((EntityPainting)e, enumArt);
                    }
                } else {
                    PaintingSelection.proxy.displayPaintingSelectionScreen(message);
                }
            });
            return null;
        }

        protected EntityPainting.EnumArt getEnumArt(String artName) {
            for (EntityPainting.EnumArt art : EntityPainting.EnumArt.values()) {
                if (!art.field_75702_A.equals(artName)) continue;
                return art;
            }
            return EntityPainting.EnumArt.KEBAB;
        }

        protected void setPaintingArt(EntityPainting p, EntityPainting.EnumArt art) {
            NBTTagCompound tag = new NBTTagCompound();
            p.func_70014_b(tag);
            tag.func_74778_a("Motive", art.field_75702_A);
            p.func_70037_a(tag);
        }
    }
}

