/*
 * Decompiled with CFR 0.152.
 */
package com.mcf.davidee.paintinggui.gui;

import com.mcf.davidee.guilib.basic.BasicScreen;
import com.mcf.davidee.guilib.basic.Label;
import com.mcf.davidee.guilib.core.Button;
import com.mcf.davidee.guilib.core.Container;
import com.mcf.davidee.guilib.core.Scrollbar;
import com.mcf.davidee.guilib.core.Widget;
import com.mcf.davidee.guilib.vanilla.ButtonVanilla;
import com.mcf.davidee.guilib.vanilla.ScrollbarVanilla;
import com.mcf.davidee.paintinggui.gui.PaintingButton;
import com.mcf.davidee.paintinggui.packet.NetworkHandler;
import com.mcf.davidee.paintinggui.packet.SPacketPainting;
import java.util.ArrayList;
import net.minecraft.entity.item.EntityPainting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PaintingSelectionScreen
extends BasicScreen
implements Button.ButtonHandler {
    private Container container;
    private Container paintingContainer;
    private Scrollbar scrollbar;
    private Label title;
    private Button back;
    private PaintingButton[] buttons;
    private final int paintingID;
    private final String[] art;

    public PaintingSelectionScreen(String[] art, int paintingID) {
        super(null);
        this.art = art;
        this.paintingID = paintingID;
    }

    @Override
    protected void reopenedGui() {
    }

    @Override
    public void drawBackground() {
        super.drawBackground();
        if (this.paintingContainer != null) {
            PaintingSelectionScreen.func_73734_a((int)this.paintingContainer.left(), (int)this.paintingContainer.top(), (int)(this.paintingContainer.right() - 10), (int)this.paintingContainer.bottom(), (int)0x44444444);
        }
    }

    @Override
    protected void unhandledKeyTyped(char c, int code) {
        if (code == 1) {
            this.close();
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.field_146297_k.field_71439_g == null || !this.field_146297_k.field_71439_g.func_70089_S()) {
            this.close();
        }
    }

    @Override
    protected void revalidateGui() {
        int START_X = 10;
        int START_Y = 30;
        int END_X = this.field_146294_l - 10;
        int GAP = 5;
        this.title.setPosition(this.field_146294_l / 2, 10);
        this.back.setPosition(this.field_146294_l / 2 - 100, this.field_146295_m - 25);
        this.scrollbar.setPosition(this.field_146294_l - 10, 28);
        int x = 10;
        int y = 30;
        int prevHeight = this.buttons[0].getHeight();
        int rowStartIndex = 0;
        for (int index = 0; index < this.buttons.length; ++index) {
            PaintingButton cur = this.buttons[index];
            if (x + cur.getWidth() > END_X || prevHeight > cur.getHeight()) {
                this.centerRow(rowStartIndex, index - 1);
                rowStartIndex = index;
                x = 10;
                y += 5 + prevHeight;
                prevHeight = cur.getHeight();
            }
            cur.setPosition(x, y);
            x += cur.getWidth() + 5;
        }
        this.centerRow(rowStartIndex, this.buttons.length - 1);
        this.paintingContainer.revalidate(10, 28, this.field_146294_l - 10, this.field_146295_m - 55);
        this.container.revalidate(0, 0, this.field_146294_l, this.field_146295_m);
    }

    private void centerRow(int start, int end) {
        int left = this.buttons[start].getX();
        int right = this.buttons[end].getX() + this.buttons[end].getWidth();
        int correction = (this.field_146294_l - 20 - (right - left)) / 2;
        for (int i = start; i <= end; ++i) {
            this.buttons[i].shiftX(correction);
        }
    }

    @Override
    protected void createGui() {
        this.scrollbar = new ScrollbarVanilla(10);
        this.paintingContainer = new Container(this.scrollbar, 0, 4);
        this.container = new Container();
        this.title = new Label("Select a Painting", new Widget[0]);
        this.back = new ButtonVanilla("Cancel", new BasicScreen.CloseHandler());
        EntityPainting.EnumArt[] enumArts = EntityPainting.EnumArt.values();
        ArrayList<EntityPainting.EnumArt> validArts = new ArrayList<EntityPainting.EnumArt>();
        block0: for (String s : this.art) {
            for (EntityPainting.EnumArt enumArt : enumArts) {
                if (!enumArt.field_75702_A.equals(s)) continue;
                validArts.add(enumArt);
                continue block0;
            }
        }
        EntityPainting.EnumArt[] validArtsArray = validArts.toArray(new EntityPainting.EnumArt[0]);
        this.buttons = new PaintingButton[validArtsArray.length];
        for (int i = 0; i < validArtsArray.length; ++i) {
            this.buttons[i] = new PaintingButton(validArtsArray[i], this);
        }
        this.container.addWidgets(this.title, this.back);
        this.paintingContainer.addWidgets(this.buttons);
        this.containers.add(this.paintingContainer);
        this.containers.add(this.container);
        this.selectedContainer = this.paintingContainer;
    }

    @Override
    public void buttonClicked(Button button) {
        String artTitle = ((PaintingButton)button).art.field_75702_A;
        NetworkHandler.NETWORK.sendToServer((IMessage)new SPacketPainting(this.paintingID, new String[]{artTitle}));
        this.field_146297_k.func_147108_a(null);
    }
}

