/*
 * Decompiled with CFR 0.152.
 */
package com.mcf.davidee.guilib.vanilla.sliders;

import com.mcf.davidee.guilib.core.Slider;
import com.mcf.davidee.guilib.vanilla.SliderVanilla;
import net.minecraft.util.math.MathHelper;

public class IntSlider
extends SliderVanilla {
    protected final int minVal;
    protected final int maxVal;
    protected final String nameFormat;
    protected boolean hover;

    public IntSlider(int width, int height, String nameFormat, int val, int minVal, int maxVal) {
        super(width, height, IntSlider.getFloatValue(val, minVal, maxVal), null);
        this.format = new IntSliderFormat();
        this.nameFormat = nameFormat;
        this.minVal = minVal;
        this.maxVal = maxVal;
    }

    public IntSlider(String name, int val, int minVal, int maxVal) {
        this(150, 20, name, val, minVal, maxVal);
    }

    @Override
    public void draw(int mx, int my) {
        this.hover = this.inBounds(mx, my);
        super.draw(mx, my);
    }

    @Override
    public boolean mouseWheel(int delta) {
        if (this.hover && !this.dragging) {
            this.value = IntSlider.getFloatValue(this.getIntValue() + (int)Math.signum(delta), this.minVal, this.maxVal);
            return true;
        }
        return false;
    }

    public static float getFloatValue(int val, int min, int max) {
        val = MathHelper.func_76125_a((int)val, (int)min, (int)max);
        return (float)(val - min) / (float)(max - min);
    }

    public void setIntValue(int val) {
        this.value = MathHelper.func_76131_a((float)IntSlider.getFloatValue(val, this.minVal, this.maxVal), (float)0.0f, (float)1.0f);
    }

    public int getIntValue() {
        return Math.round(this.value * (float)(this.maxVal - this.minVal) + (float)this.minVal);
    }

    protected class IntSliderFormat
    implements Slider.SliderFormat {
        protected IntSliderFormat() {
        }

        @Override
        public String format(Slider slider) {
            return String.format(IntSlider.this.nameFormat, IntSlider.this.getIntValue());
        }
    }
}

