/*
 * Decompiled with CFR 0.152.
 */
package com.mcf.davidee.guilib.core;

import com.mcf.davidee.guilib.focusable.FocusableWidget;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;

public abstract class TextField
extends FocusableWidget {
    protected String text = "";
    protected int maxLength = 32;
    protected boolean focused;
    protected int cursorCounter;
    protected int cursorPosition;
    protected int charOffset;
    protected int selectionEnd;
    protected int color;
    protected CharacterFilter filter;

    public TextField(int width, int height, CharacterFilter filter) {
        super(width, height);
        this.filter = filter;
        this.color = 0xFFFFFF;
    }

    protected abstract int getDrawX();

    protected abstract int getDrawY();

    public abstract int getInternalWidth();

    protected abstract void drawBackground();

    @Override
    public void draw(int mx, int my) {
        this.drawBackground();
        int j = this.cursorPosition - this.charOffset;
        int k = this.selectionEnd - this.charOffset;
        String s = this.mc.field_71466_p.func_78269_a(this.text.substring(this.charOffset), this.getInternalWidth());
        boolean flag = j >= 0 && j <= s.length();
        boolean cursor = this.focused && this.cursorCounter / 6 % 2 == 0 && flag;
        int l = this.getDrawX();
        int i1 = this.getDrawY();
        int j1 = l;
        if (k > s.length()) {
            k = s.length();
        }
        if (s.length() > 0) {
            String s1 = flag ? s.substring(0, j) : s;
            j1 = this.mc.field_71466_p.func_175063_a(s1, (float)l, (float)i1, this.color);
        }
        boolean flag2 = this.cursorPosition < this.text.length() || this.text.length() >= this.maxLength;
        int k1 = j1;
        if (!flag) {
            k1 = j > 0 ? l + this.width : l;
        } else if (flag2) {
            k1 = j1 - 1;
            --j1;
        }
        if (s.length() > 0 && flag && j < s.length()) {
            this.mc.field_71466_p.func_175063_a(s.substring(j), (float)j1, (float)i1, this.color);
        }
        if (cursor) {
            if (flag2) {
                Gui.func_73734_a((int)k1, (int)(i1 - 1), (int)(k1 + 1), (int)(i1 + 1 + this.mc.field_71466_p.field_78288_b), (int)-3092272);
            } else {
                this.mc.field_71466_p.func_175063_a("_", (float)k1, (float)i1, this.color);
            }
        }
        if (k != j) {
            int l1 = l + this.mc.field_71466_p.func_78256_a(s.substring(0, k));
            this.drawCursorVertical(k1, i1 - 1, l1 - 1, i1 + 1 + this.mc.field_71466_p.field_78288_b);
        }
    }

    protected void drawCursorVertical(int startX, int startY, int endX, int endY) {
        int temp;
        if (startX < endX) {
            temp = startX;
            startX = endX;
            endX = temp;
        }
        if (startY < endY) {
            temp = startY;
            startY = endY;
            endY = temp;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179115_u();
        GlStateManager.func_187422_a((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)startX, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)endX, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)endX, (double)startY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)startX, (double)startY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179134_v();
        GlStateManager.func_179098_w();
    }

    @Override
    public boolean click(int mx, int my) {
        return this.inBounds(mx, my);
    }

    @Override
    public void handleClick(int mx, int my) {
        int pos = mx - this.x;
        String s = this.mc.field_71466_p.func_78269_a(this.text.substring(this.charOffset), this.getWidth());
        this.setCursorPosition(this.mc.field_71466_p.func_78269_a(s, pos -= Math.abs(this.getInternalWidth() - this.width) / 2).length() + this.charOffset);
    }

    @Override
    public void update() {
        ++this.cursorCounter;
    }

    @Override
    public void focusGained() {
        this.cursorCounter = 0;
        this.focused = true;
    }

    @Override
    public void focusLost() {
        this.focused = false;
    }

    public String getText() {
        return this.text;
    }

    public void setMaxLength(int length) {
        this.maxLength = length;
        if (this.text.length() > length) {
            this.text = this.text.substring(0, length);
        }
    }

    public void setColor(int color) {
        this.color = color;
    }

    public String getSelectedtext() {
        int start = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int end = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        return this.text.substring(start, end);
    }

    public void setText(String str) {
        this.text = str.length() > this.maxLength ? str.substring(0, this.maxLength) : str;
        this.setCursorPosition(this.text.length());
    }

    public void moveCursorBy(int offs) {
        this.setCursorPosition(this.selectionEnd + offs);
    }

    public void writeText(String str) {
        int l;
        String s1 = "";
        str = this.filter.filter(str);
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        int k = this.maxLength - this.text.length() - (i - this.selectionEnd);
        if (this.text.length() > 0) {
            s1 = s1 + this.text.substring(0, i);
        }
        if (k < str.length()) {
            s1 = s1 + str.substring(0, k);
            l = k;
        } else {
            s1 = s1 + str;
            l = str.length();
        }
        if (this.text.length() > 0 && j < this.text.length()) {
            s1 = s1 + this.text.substring(j);
        }
        this.text = s1;
        this.moveCursorBy(i - this.selectionEnd + l);
    }

    public void deleteFromCursor(int amt) {
        if (this.text.length() > 0) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                boolean flag = amt < 0;
                int j = flag ? this.cursorPosition + amt : this.cursorPosition;
                int k = flag ? this.cursorPosition : this.cursorPosition + amt;
                String s = "";
                if (j >= 0) {
                    s = this.text.substring(0, j);
                }
                if (k < this.text.length()) {
                    s = s + this.text.substring(k);
                }
                this.text = s;
                if (flag) {
                    this.moveCursorBy(amt);
                }
            }
        }
    }

    public void setCursorPosition(int index) {
        this.cursorPosition = MathHelper.func_76125_a((int)index, (int)0, (int)this.text.length());
        this.setSelectionPos(this.cursorPosition);
    }

    public void setSelectionPos(int index) {
        this.selectionEnd = index = MathHelper.func_76125_a((int)index, (int)0, (int)this.text.length());
        if (this.charOffset > index) {
            this.charOffset = index;
        }
        int width = this.getInternalWidth();
        String s = this.mc.field_71466_p.func_78269_a(this.text.substring(this.charOffset), width);
        int pos = s.length() + this.charOffset;
        if (index == this.charOffset) {
            this.charOffset -= this.mc.field_71466_p.func_78262_a(this.text, width, true).length();
        }
        if (index > pos) {
            this.charOffset += index - 1;
        } else if (index <= this.charOffset) {
            this.charOffset = index;
        }
        this.charOffset = MathHelper.func_76125_a((int)this.charOffset, (int)0, (int)this.text.length());
    }

    @Override
    public boolean keyTyped(char par1, int par2) {
        if (this.focused) {
            switch (par1) {
                case '\u0001': {
                    this.setCursorPosition(this.text.length());
                    this.setSelectionPos(0);
                    return true;
                }
                case '\u0003': {
                    GuiScreen.func_146275_d((String)this.getSelectedtext());
                    return true;
                }
                case '\u0016': {
                    this.writeText(GuiScreen.func_146277_j());
                    return true;
                }
                case '\u0018': {
                    GuiScreen.func_146275_d((String)this.getSelectedtext());
                    this.writeText("");
                    return true;
                }
            }
            switch (par2) {
                case 14: {
                    this.deleteFromCursor(-1);
                    return true;
                }
                case 199: {
                    this.setSelectionPos(0);
                    this.setCursorPosition(0);
                    return true;
                }
                case 203: {
                    if (GuiScreen.func_146272_n()) {
                        this.setSelectionPos(this.selectionEnd - 1);
                    } else {
                        this.moveCursorBy(-1);
                    }
                    return true;
                }
                case 205: {
                    if (GuiScreen.func_146272_n()) {
                        this.setSelectionPos(this.selectionEnd + 1);
                    } else {
                        this.moveCursorBy(1);
                    }
                    return true;
                }
                case 207: {
                    if (GuiScreen.func_146272_n()) {
                        this.setSelectionPos(this.text.length());
                    } else {
                        this.setCursorPosition(this.text.length());
                    }
                    return true;
                }
                case 211: {
                    this.deleteFromCursor(1);
                    return true;
                }
            }
            if (this.filter.isAllowedCharacter(par1)) {
                this.writeText(Character.toString(par1));
                return true;
            }
            return false;
        }
        return false;
    }

    public static interface CharacterFilter {
        public String filter(String var1);

        public boolean isAllowedCharacter(char var1);
    }
}

