/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal.network;

import com.google.common.base.Strings;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import shetiphian.core.common.NameHelper;
import shetiphian.core.common.network.PacketBase;
import shetiphian.core.common.network.PacketPipeline;
import shetiphian.core.internal.network.NetworkHandler;

public class PacketNameSync
extends PacketBase {
    private String id;
    private String name;

    public PacketNameSync() {
    }

    public PacketNameSync(UUID uuid, String name) {
        this.id = uuid.toString();
        this.name = name;
    }

    public PacketNameSync(String teamID, String name) {
        this.id = teamID;
        this.name = name;
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        if (!Strings.isNullOrEmpty((String)this.id)) {
            buffer.writeBoolean(true);
            buffer.func_180714_a(this.id);
        } else {
            buffer.writeBoolean(false);
        }
        if (!Strings.isNullOrEmpty((String)this.name)) {
            buffer.writeBoolean(true);
            buffer.func_180714_a(this.name);
        } else {
            buffer.writeBoolean(false);
        }
    }

    @Override
    public void fromBytes(PacketBuffer buffer) {
        if (buffer.readBoolean()) {
            this.id = buffer.func_150789_c(Short.MAX_VALUE);
        }
        if (buffer.readBoolean()) {
            this.name = buffer.func_150789_c(Short.MAX_VALUE);
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        if (!Strings.isNullOrEmpty((String)this.id) && !Strings.isNullOrEmpty((String)this.name)) {
            NameHelper.set(this.id, this.name);
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        if (!Strings.isNullOrEmpty((String)this.id) && player instanceof EntityPlayerMP) {
            String display = NameHelper.getDisplayNameFor(this.id);
            if (Strings.isNullOrEmpty((String)this.name) || !display.equalsIgnoreCase(this.name)) {
                NetworkHandler.sendToPlayer(new PacketNameSync(this.id, display), (EntityPlayerMP)player);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<PacketNameSync, IMessage> {
        public IMessage onMessage(PacketNameSync packet, MessageContext ctx) {
            PacketPipeline.onMessage(packet, ctx);
            return null;
        }
    }
}

