/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal.modintegration.ftblib;

import com.feed_the_beast.ftbl.api.FTBLibAPI;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.IForgeTeam;
import com.feed_the_beast.ftbl.api.IUniverse;
import com.feed_the_beast.ftbl.api.player.ForgePlayerLoggedInEvent;
import com.feed_the_beast.ftbl.api.team.ForgeTeamPlayerJoinedEvent;
import com.feed_the_beast.ftbl.api.team.ForgeTeamPlayerLeftEvent;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import shetiphian.core.internal.modintegration.ftblib.FTBLib_Base;
import shetiphian.core.internal.network.NetworkHandler;
import shetiphian.core.internal.network.PacketFTBMyTeam;

public class FTBLib_v4_Active
extends FTBLib_Base {
    public static void init() {
        if (FTBLibAPI.class != null) {
            FTBLib_Base.INSTANCE = new FTBLib_v4_Active();
            MinecraftForge.EVENT_BUS.register((Object)new FTBEventHandler());
        }
    }

    @Override
    public String getPlayerTeamID(EntityPlayer player) {
        if (player != null) {
            if (player.field_70170_p.field_72995_K) {
                return this.myTeam;
            }
            try {
                IUniverse universe = FTBLibAPI.API.getUniverse();
                UUID uuid = player.func_110124_au();
                IForgePlayer forgePlayer = universe.getPlayer(uuid);
                if (forgePlayer != null) {
                    IForgeTeam team = forgePlayer.getTeam();
                    return team != null ? team.func_176610_l() : "";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    @Override
    public String getTeamName(String teamID) {
        try {
            IUniverse universe = FTBLibAPI.API.getUniverse();
            IForgeTeam team = universe.getTeam(teamID);
            return team != null ? team.getTitle() : "";
        }
        catch (Exception exception) {
            return teamID;
        }
    }

    private static class FTBEventHandler {
        private FTBEventHandler() {
        }

        @SubscribeEvent
        public void forgePlayerLoggedIn(ForgePlayerLoggedInEvent event) {
            IForgePlayer forgePlayer = event.getPlayer();
            IForgeTeam team = forgePlayer.getTeam();
            NetworkHandler.sendToPlayer(new PacketFTBMyTeam(team != null ? team.func_176610_l() : null), forgePlayer.getPlayer());
        }

        @SubscribeEvent
        public void forgeTeamPlayerJoined(ForgeTeamPlayerJoinedEvent event) {
            IForgePlayer forgePlayer = event.getPlayer();
            IForgeTeam team = event.getTeam();
            NetworkHandler.sendToPlayer(new PacketFTBMyTeam(team != null ? team.func_176610_l() : null), forgePlayer.getPlayer());
        }

        @SubscribeEvent
        public void forgeTeamPlayerLeft(ForgeTeamPlayerLeftEvent event) {
            IForgePlayer forgePlayer = event.getPlayer();
            NetworkHandler.sendToPlayer(new PacketFTBMyTeam(null), forgePlayer.getPlayer());
        }
    }
}

