/*
 * Decompiled with CFR 0.152.
 */
package mirror.normalasm.client.models.bucket.mixins;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.vecmath.Quat4f;
import mirror.normalasm.bakedquad.BakedQuadFactory;
import mirror.normalasm.client.models.bucket.NormalBakedDynBucket;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.ModelDynBucket;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.Fluid;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ModelDynBucket.class}, remap=false)
public abstract class ModelDynBucketMixin
implements IModel {
    @Shadow
    @Final
    private static float NORTH_Z_COVER;
    @Shadow
    @Final
    private static float SOUTH_Z_COVER;
    @Shadow
    @Final
    private static float NORTH_Z_FLUID;
    @Shadow
    @Final
    private static float SOUTH_Z_FLUID;
    @Shadow
    @Final
    private boolean flipGas;
    @Shadow
    @Final
    @Nullable
    private Fluid fluid;
    @Shadow
    @Final
    @Nullable
    private ResourceLocation baseLocation;
    @Shadow
    @Final
    @Nullable
    private ResourceLocation liquidLocation;
    @Shadow
    @Final
    @Nullable
    private ResourceLocation coverLocation;
    @Shadow
    @Final
    private boolean tint;

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((IModelState)state);
        boolean flipped = false;
        if (this.flipGas && this.fluid != null && this.fluid.isLighterThanAir()) {
            flipped = true;
            state = new ModelStateComposition(state, (IModelState)TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(null, new Quat4f(0.0f, 0.0f, 1.0f, 0.0f), null, null)));
        }
        TRSRTransformation transform = state.apply(Optional.empty()).orElse(TRSRTransformation.identity());
        TextureAtlasSprite fluidSprite = null;
        TextureAtlasSprite particleSprite = null;
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.fluid != null) {
            fluidSprite = bakedTextureGetter.apply(this.fluid.getStill());
        }
        if (this.baseLocation != null) {
            Map<ResourceLocation, Pair<ResourceLocation, BakedQuad[]>> map = flipped ? NormalBakedDynBucket.flippedBaseQuads : NormalBakedDynBucket.baseQuads;
            Pair baseQuad = map.get(this.baseLocation);
            if (baseQuad == null) {
                IBakedModel model = new ItemLayerModel(ImmutableList.of((Object)this.baseLocation)).bake(state, format, bakedTextureGetter);
                baseQuad = Pair.of((Object)new ResourceLocation(model.func_177554_e().func_94215_i()), (Object)model.func_188616_a(null, null, 0L).toArray(new BakedQuad[0]));
                map.put(this.baseLocation, (Pair<ResourceLocation, BakedQuad[]>)baseQuad);
            }
            builder.add((Object[])baseQuad.getRight());
            particleSprite = bakedTextureGetter.apply((ResourceLocation)baseQuad.getLeft());
        }
        if (this.liquidLocation != null && fluidSprite != null) {
            TextureAtlasSprite liquid = bakedTextureGetter.apply(this.liquidLocation);
            builder.add((Object[])Stream.of(ItemTextureQuadConverter.convertTexture((VertexFormat)format, (TRSRTransformation)transform, (TextureAtlasSprite)liquid, (TextureAtlasSprite)fluidSprite, (float)NORTH_Z_FLUID, (EnumFacing)EnumFacing.NORTH, (int)(this.tint ? this.fluid.getColor() : -1), (int)1), ItemTextureQuadConverter.convertTexture((VertexFormat)format, (TRSRTransformation)transform, (TextureAtlasSprite)liquid, (TextureAtlasSprite)fluidSprite, (float)SOUTH_Z_FLUID, (EnumFacing)EnumFacing.SOUTH, (int)(this.tint ? this.fluid.getColor() : -1), (int)1)).flatMap(Collection::stream).map(ubq -> BakedQuadFactory.create(ubq.func_178209_a(), ubq.func_178211_c(), ubq.func_178210_d(), ubq.func_187508_a(), ubq.shouldApplyDiffuseLighting(), ubq.getFormat())).toArray(BakedQuad[]::new));
            particleSprite = fluidSprite;
        }
        if (this.coverLocation != null) {
            TextureAtlasSprite cover = bakedTextureGetter.apply(this.coverLocation);
            Map<ResourceLocation, BakedQuad[]> map = flipped ? NormalBakedDynBucket.flippedCoverQuads : NormalBakedDynBucket.coverQuads;
            Object[] quads = map.get(this.coverLocation);
            if (quads == null) {
                quads = (BakedQuad[])Stream.of(ItemTextureQuadConverter.genQuad((VertexFormat)format, (TRSRTransformation)transform, (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)NORTH_Z_COVER, (TextureAtlasSprite)cover, (EnumFacing)EnumFacing.NORTH, (int)-1, (int)2), ItemTextureQuadConverter.genQuad((VertexFormat)format, (TRSRTransformation)transform, (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)SOUTH_Z_COVER, (TextureAtlasSprite)cover, (EnumFacing)EnumFacing.SOUTH, (int)-1, (int)2)).map(ubq -> BakedQuadFactory.create(ubq.func_178209_a(), ubq.func_178211_c(), ubq.func_178210_d(), ubq.func_187508_a(), ubq.shouldApplyDiffuseLighting(), ubq.getFormat())).toArray(BakedQuad[]::new);
                map.put(this.coverLocation, (BakedQuad[])quads);
            }
            builder.add(quads);
            if (particleSprite == null) {
                particleSprite = cover;
            }
        }
        return new NormalBakedDynBucket((ModelDynBucket)this, (ImmutableList<BakedQuad>)builder.build(), particleSprite, format, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)transformMap, transform.isIdentity());
    }
}

