/*
 * Decompiled with CFR 0.152.
 */
package mirror.normalasm.client.models;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import mirror.normalasm.NormalLogger;
import mirror.normalasm.NormalReflector;
import mirror.normalasm.api.HashingStrategies;
import mirror.normalasm.api.NormalStringPool;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.TRSRTransformation;
import scala.collection.mutable.MultiMap;

public class Deduplicator {
    private static final MethodHandle UNPACKED_DATA_GETTER = NormalReflector.resolveFieldGetter(UnpackedBakedQuad.class, "unpackedData");
    private static final MethodHandle SIMPLE_BAKED_MODEL_FACE_QUADS_GETTER = NormalReflector.resolveFieldGetter(SimpleBakedModel.class, "faceQuads", "field_177561_b");
    private static final MethodHandle SIMPLE_BAKED_MODEL_FACE_QUADS_SETTER = NormalReflector.resolveFieldSetter(SimpleBakedModel.class, "faceQuads", "field_177561_b");
    private static final MethodHandle PERSPECTIVE_MAP_WRAPPER_TRANSFORMS_GETTER = NormalReflector.resolveFieldGetter(PerspectiveMapWrapper.class, "transforms");
    private static final MethodHandle PERSPECTIVE_MAP_WRAPPER_TRANSFORMS_SETTER = NormalReflector.resolveFieldSetter(PerspectiveMapWrapper.class, "transforms");
    private static final MethodHandle BAKED_ITEM_MODEL_TRANSFORMS_GETTER = NormalReflector.resolveFieldGetter(BakedItemModel.class, "transforms");
    private static final MethodHandle BAKED_ITEM_MODEL_TRANSFORMS_SETTER = NormalReflector.resolveFieldSetter(BakedItemModel.class, "transforms");
    private static final MethodHandle ITEM_OVERRIDE_LIST_OVERRIDES_GETTER = NormalReflector.resolveFieldGetter(ItemOverrideList.class, "overrides", "field_188023_b");
    private static final MethodHandle ITEM_OVERRIDE_LIST_OVERRIDES_SETTER = NormalReflector.resolveFieldSetter(ItemOverrideList.class, "overrides", "field_188023_b");
    private static final MethodHandle BLOCK_PART_FACE_TEXTURE_GETTER = NormalReflector.resolveFieldGetter(BlockPartFace.class, "texture", "field_178242_d");
    private static final MethodHandle BLOCK_PART_FACE_TEXTURE_SETTER = NormalReflector.resolveFieldSetter(BlockPartFace.class, "texture", "field_178242_d");
    private static final ImmutableMap<Placeholder, Object> immutableEnumMap;
    private final ObjectOpenCustomHashSet<Object> identityCanonicals = new ObjectOpenCustomHashSet(HashingStrategies.IDENTITY_OBJECT_HASH);
    private final ObjectOpenCustomHashSet<Object> genericCanonicals = new ObjectOpenCustomHashSet(HashingStrategies.GENERIC_OBJECT_HASH);
    private final ObjectOpenCustomHashSet<float[]> floatArrayCache = new ObjectOpenCustomHashSet(FloatArrays.HASH_STRATEGY);
    private final ObjectOpenCustomHashSet<float[][]> float2dArrayCache = new ObjectOpenCustomHashSet(HashingStrategies.FLOAT_2D_ARRAY_HASH);
    private final ObjectOpenCustomHashSet<Object> genericObjectCache = new ObjectOpenCustomHashSet(HashingStrategies.IDENTITY_OBJECT_HASH);
    private final ObjectOpenCustomHashSet<ItemCameraTransforms> itemCameraTransformsCache = new ObjectOpenCustomHashSet(HashingStrategies.ITEM_CAMERA_TRANSFORMS_HASH);

    public final Object deduplicate(Object o) {
        if (o == null) {
            return null;
        }
        Object n = this.genericCanonicals.addOrGet(o);
        if (n != o) {
            return o;
        }
        if (o instanceof IBakedModel) {
            if (o instanceof SimpleBakedModel) {
                this.trim(((IBakedModel)o).func_188616_a(null, null, 0L));
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    this.trim(((IBakedModel)o).func_188616_a(null, facing, 0L));
                }
                try {
                    Map faceQuads = SIMPLE_BAKED_MODEL_FACE_QUADS_GETTER.invokeExact((SimpleBakedModel)o);
                    if (!(faceQuads instanceof EnumMap)) {
                        NormalLogger.instance.debug("Found a non-EnumMap faceQuads instance! Preparing to transform");
                        SIMPLE_BAKED_MODEL_FACE_QUADS_SETTER.invokeExact((SimpleBakedModel)o, new EnumMap(faceQuads));
                    }
                }
                catch (Throwable t) {
                    NormalLogger.instance.throwing(t);
                }
                return o;
            }
            if (o instanceof PerspectiveMapWrapper) {
                try {
                    Object newTransforms;
                    Object transforms = PERSPECTIVE_MAP_WRAPPER_TRANSFORMS_GETTER.invoke(o);
                    if (transforms != null && transforms != (newTransforms = this.canonicalize(transforms))) {
                        NormalLogger.instance.debug("Canonized PerspectiveMapWrapper#transforms successfully.");
                        PERSPECTIVE_MAP_WRAPPER_TRANSFORMS_SETTER.invoke((PerspectiveMapWrapper)o, newTransforms);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        return o;
    }

    private Object canonicalize(Object o) {
        Object n = o;
        if (o instanceof float[]) {
            n = this.floatArrayCache.addOrGet((Object)((float[])o));
        } else if (o instanceof float[][]) {
            float[][] o2 = (float[][])this.float2dArrayCache.addOrGet((Object)((float[][])o));
            if (o == o2) {
                for (int i = 0; i < o2.length; ++i) {
                    o2[i] = (float[])this.canonicalize(o2[i]);
                }
            } else {
                n = o2;
            }
        } else if (o instanceof float[][][]) {
            float[][][] o2 = (float[][][])o;
            for (int i = 0; i < o2.length; ++i) {
                o2[i] = (float[][])this.canonicalize(o2[i]);
            }
        } else if (o instanceof Map) {
            if (o instanceof ImmutableMap && ((Map)o).isEmpty() && n != ImmutableMap.of()) {
                n = ImmutableMap.of();
            } else if (o.getClass() != immutableEnumMap.getClass() && !((Map)o).isEmpty() && ((Map)o).keySet().toArray()[0] instanceof Enum) {
                n = new EnumMap((Map)o);
            }
        } else if (o instanceof Collection || o instanceof MultiMap || o instanceof ResourceLocation || o instanceof Vec3d || o instanceof Vec3i || o instanceof TRSRTransformation) {
            n = this.genericObjectCache.addOrGet(o);
        } else if (o instanceof ItemCameraTransforms) {
            n = this.itemCameraTransformsCache.addOrGet((Object)((ItemCameraTransforms)o));
        } else if (o instanceof String) {
            n = NormalStringPool.canonicalize((String)o);
        }
        if (n != o) {
            NormalLogger.instance.info("Deduplicated {}@{} => {}@{} successfully", (Object)o.getClass().getName(), (Object)Integer.toHexString(o.hashCode()), (Object)n.getClass().getName(), (Object)Integer.toHexString(n.hashCode()));
        }
        return n;
    }

    private void trim(Object o) {
        if (o instanceof ArrayList) {
            ((ArrayList)o).trimToSize();
        }
    }

    static {
        EnumMap<Placeholder, Placeholder> placeholderEnumMap = new EnumMap<Placeholder, Placeholder>(Placeholder.class);
        placeholderEnumMap.put(Placeholder.ONE, Placeholder.ONE);
        placeholderEnumMap.put(Placeholder.TWO, Placeholder.TWO);
        placeholderEnumMap.put(Placeholder.THREE, Placeholder.THREE);
        immutableEnumMap = Maps.immutableEnumMap(placeholderEnumMap);
    }

    private static enum Placeholder {
        ONE,
        TWO,
        THREE;

    }
}

